/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.ui.popup.OpenFileListener;
import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import edu.uwyo.crawl.ui.tree.AbstractFileNodePopup;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import edu.uwyo.crawl.ui.tree.FileNodeToolTipTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.tree.TreePath;

public class FileTreeMouseListener
extends MouseAdapter {
    private static final int SHIFT_CLICK = 1088;
    private int startRow;
    private int endRow;
    private int lastRowCount;
    private FileDisplayTree resultTree;
    private final FileNodeToolTipTree tree;
    private final AbstractFileNodePopup popup;

    protected FileTreeMouseListener(FileNodeToolTipTree tree, AbstractFileNodePopup popup) {
        this.tree = tree;
        this.popup = popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1 && (e.getModifiersEx() & 0x440) != 1088) {
            this.startRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
        }
        this.lastRowCount = this.tree.getRowCount();
        this.showPopup(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.endRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
        this.selectRange();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1 && (e.getModifiersEx() & 0x80) == 0) {
            if (this.lastRowCount != this.tree.getRowCount()) {
                this.lastRowCount = this.tree.getRowCount();
                this.endRow = this.startRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            } else {
                this.endRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
                this.selectRange();
            }
        }
        this.showPopup(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            int[] rows = this.tree.getSelectionRows();
            AbstractFileNode[] nodes = new AbstractFileNode[rows.length];
            int i = 0;
            while (i < rows.length) {
                TreePath path = this.tree.getPathForRow(rows[i]);
                nodes[i] = (AbstractFileNode)path.getLastPathComponent();
                ++i;
            }
            OpenFileListener.openFiles(nodes);
        }
    }

    protected void setTree(FileDisplayTree resultTree) {
        this.resultTree = resultTree;
        this.popup.setTree(resultTree);
    }

    private void selectRange() {
        if (this.endRow == this.startRow) {
            this.tree.setSelectionRow(this.startRow);
            return;
        }
        int start = this.startRow;
        int end = this.endRow;
        if (start > end) {
            int temp = start;
            start = end;
            end = temp;
        }
        int[] rows = new int[end - start + 1];
        int i = 0;
        while (i < rows.length) {
            rows[i] = start + i;
            ++i;
        }
        this.tree.setSelectionRows(rows);
    }

    private void showPopup(MouseEvent e) {
        if (this.popup != null && e.isPopupTrigger()) {
            int currRow = this.tree.getClosestRowForLocation(e.getX(), e.getY());
            boolean currInSelection = false;
            int[] rows = this.tree.getSelectionRows();
            int i = 0;
            while (i < rows.length) {
                if (rows[i] == currRow) {
                    currInSelection = true;
                    break;
                }
                ++i;
            }
            if (!currInSelection) {
                this.tree.setSelectionRow(currRow);
                rows = this.tree.getSelectionRows();
            }
            AbstractFileNode[] nodes = new AbstractFileNode[rows.length];
            int i2 = 0;
            while (i2 < rows.length) {
                TreePath path = this.tree.getPathForRow(rows[i2]);
                nodes[i2] = (AbstractFileNode)path.getLastPathComponent();
                ++i2;
            }
            this.popup.show(nodes, this.resultTree != null && this.resultTree.isFlat(), e);
        }
    }
}

