/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import edu.uwyo.crawl.ui.tree.AbstractFileNodePopup;
import edu.uwyo.crawl.ui.tree.FileNodeToolTipTree;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.tree.TreePath;

public class FileTreeKeyListener
implements KeyListener {
    private final FileNodeToolTipTree tree;
    private final AbstractFileNodePopup popup;

    protected FileTreeKeyListener(FileNodeToolTipTree tree, AbstractFileNodePopup popup) {
        this.tree = tree;
        this.popup = popup;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int[] rows;
        if (this.popup != null && (rows = this.tree.getSelectionRows()) != null && rows.length > 0) {
            AbstractFileNode[] nodes = new AbstractFileNode[rows.length];
            int i = 0;
            while (i < rows.length) {
                TreePath path = this.tree.getPathForRow(rows[i]);
                nodes[i] = (AbstractFileNode)path.getLastPathComponent();
                ++i;
            }
            if (this.popup.pressKey(nodes, e)) {
                this.tree.setSelectionRow(-1);
                this.tree.setSelectionRows(rows);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

