/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import edu.uwyo.crawl.database.DataInput;
import edu.uwyo.crawl.database.DataOutput;
import edu.uwyo.crawl.database.Serializer;
import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class FileDisplayTree
implements Serializable,
Serializer<FileDisplayTree> {
    public static final FileDisplayTree INSTANCE = new FileDisplayTree();
    private static final String DELIMITERS = "[\\\\\\/]+";
    private static final long serialVersionUID = 1994080994513940074L;
    private boolean isRoot;
    private boolean flatMode;
    private int size;
    private String filePath;
    private String path;
    private long fileSize;
    private HashMap<String, FileDisplayTree> children = new HashMap();

    public FileDisplayTree(String rootPath) {
        this(true, rootPath, FileDisplayTree.getRoot(rootPath));
    }

    private FileDisplayTree(boolean isRoot, String filePath, String path) {
        this();
        this.isRoot = isRoot;
        this.filePath = filePath;
        this.path = path;
    }

    private FileDisplayTree() {
    }

    @Override
    public void serialize(DataOutput output, FileDisplayTree instance) throws IOException {
        output.writeBoolean(instance.isRoot);
        output.writeBoolean(instance.flatMode);
        output.writeInt(instance.size);
        output.writeLong(instance.fileSize);
        output.writeBoolean(instance.filePath != null);
        if (instance.filePath != null) {
            output.writeUTF(instance.filePath);
        }
        output.writeBoolean(instance.path != null);
        if (instance.path != null) {
            output.writeUTF(instance.path);
        }
        Set<String> keys = instance.children.keySet();
        output.writeShort((short)keys.size());
        for (String key : keys) {
            output.writeUTF(key);
            this.serialize(output, instance.children.get(key));
        }
    }

    @Override
    public FileDisplayTree deserialize(DataInput input) throws IOException {
        FileDisplayTree toReturn = new FileDisplayTree();
        toReturn.isRoot = input.readBoolean();
        toReturn.flatMode = input.readBoolean();
        toReturn.size = input.readInt();
        toReturn.fileSize = input.readLong();
        if (input.readBoolean()) {
            toReturn.filePath = input.readUTF();
        }
        if (input.readBoolean()) {
            toReturn.path = input.readUTF();
        }
        int numChildren = input.readShort();
        int i = 0;
        while (i < numChildren) {
            String path = input.readUTF();
            FileDisplayTree value = this.deserialize(input);
            toReturn.children.put(path, value);
            ++i;
        }
        return toReturn;
    }

    public int size() {
        return this.size;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public boolean isEmpty() {
        return this.children.size() == 0;
    }

    public boolean isFlat() {
        return this.flatMode;
    }

    public void setFlatMode(boolean enabled) {
        this.flatMode = enabled;
    }

    public void clear(String rootPath) {
        if (this.isRoot) {
            this.filePath = rootPath;
            this.path = FileDisplayTree.getRoot(rootPath);
        }
        this.size = 0;
        this.fileSize = 0L;
        this.children.clear();
    }

    public String[] getPaths() {
        String[] toReturn = new String[this.size];
        this.getPaths(toReturn, 0);
        return toReturn;
    }

    public String[] getPrefixes() {
        String[] toReturn = new String[this.size];
        if (!this.flatMode) {
            return toReturn;
        }
        this.getPrefixes(toReturn, null, 0);
        return toReturn;
    }

    public long[] getPathSizes() {
        long[] toReturn = new long[this.size];
        this.getPathSizes(toReturn, 0);
        return toReturn;
    }

    public int[] getFlags(AbstractFileNode factoryNode) {
        int[] toReturn = new int[this.size];
        this.getFlags(factoryNode, toReturn, 0);
        return toReturn;
    }

    public void print(String currIndent) {
        if (this.isRoot) {
            currIndent = "";
        }
        System.out.println(String.valueOf(currIndent) + this.getPath());
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            this.children.get(child).print(String.valueOf(currIndent) + "    ");
        }
    }

    public void forceRoot(String oldRoot, String newRoot) {
        if (this.isRoot) {
            oldRoot = this.filePath;
            this.filePath = newRoot;
            this.path = FileDisplayTree.getRoot(newRoot);
        } else {
            this.filePath = this.filePath.replace(oldRoot, newRoot);
        }
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            this.children.get(child).forceRoot(oldRoot, newRoot);
        }
    }

    public void add(String prefix, String filePath, boolean isDirectory, long size) {
        if (!this.isRoot) {
            return;
        }
        if (this.flatMode) {
            FileDisplayTree childToAdd = this.children.get(prefix);
            if (childToAdd == null) {
                this.children.put(prefix, new FileDisplayTree(false, null, prefix));
                childToAdd = this.children.get(prefix);
            }
            ++this.size;
            this.fileSize += size;
            ++childToAdd.size;
            childToAdd.fileSize += size;
            FileDisplayTree newChild = new FileDisplayTree(filePath);
            newChild.size = 1;
            newChild.fileSize = size;
            childToAdd.children.put(filePath, newChild);
            return;
        }
        String absolutePath = filePath;
        if (absolutePath.startsWith(this.path)) {
            absolutePath = absolutePath.substring(this.path.length());
            while (absolutePath.startsWith("\\") || absolutePath.startsWith("/")) {
                absolutePath = absolutePath.substring(1);
            }
            String[] tokens = absolutePath.split(DELIMITERS);
            FileDisplayTree.add(isDirectory ? null : filePath, this, tokens, 0, size);
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getPath() {
        return this.path;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public HashMap<String, FileDisplayTree> getChildren() {
        return this.children;
    }

    public HashMap<String, FileDisplayTree> getChildren(Object[] paths) {
        FileDisplayTree tree = FileDisplayTree.getTree(this, paths, 0);
        return tree != null ? tree.children : null;
    }

    public FileDisplayTree getTree(Object[] paths) {
        return FileDisplayTree.getTree(this, paths, 0);
    }

    private int getPaths(String[] toPut, int index) {
        if (this.filePath != null && !this.isRoot) {
            toPut[index] = this.filePath;
            ++index;
        }
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            index = this.children.get(child).getPaths(toPut, index);
        }
        return index;
    }

    private int getPrefixes(String[] toPut, String currPrefix, int index) {
        if (this.filePath != null && !this.isRoot) {
            toPut[index] = currPrefix;
            ++index;
        }
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            index = this.isRoot ? this.children.get(child).getPrefixes(toPut, child, index) : this.children.get(child).getPrefixes(toPut, currPrefix, index);
        }
        return index;
    }

    private int getPathSizes(long[] toPut, int index) {
        if (this.filePath != null && !this.isRoot) {
            toPut[index] = this.fileSize;
            ++index;
        }
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            index = this.children.get(child).getPathSizes(toPut, index);
        }
        return index;
    }

    private int getFlags(AbstractFileNode factoryNode, int[] toPut, int index) {
        if (this.filePath != null && !this.isRoot) {
            toPut[index] = factoryNode.getFlagForPath(this.filePath);
            ++index;
        }
        Set<String> childrenSet = this.children.keySet();
        for (String child : childrenSet) {
            index = this.children.get(child).getFlags(factoryNode, toPut, index);
        }
        return index;
    }

    /*
     * Unable to fully structure code
     */
    private static String getRoot(String rootPath) {
        if (rootPath != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
lbl4:
            // 2 sources

            ** while (rootPath.endsWith((String)"\\") || rootPath.endsWith((String)"/"))
        }
lbl5:
        // 1 sources

        return rootPath;
    }

    private static void add(String filePath, FileDisplayTree curr, String[] tokens, int index, long size) {
        ++curr.size;
        curr.fileSize += size;
        if (index == tokens.length - 1) {
            FileDisplayTree leaf = new FileDisplayTree(false, filePath, tokens[index]);
            leaf.fileSize = size;
            curr.children.put(tokens[index], leaf);
            return;
        }
        FileDisplayTree child = curr.children.get(tokens[index]);
        if (child == null) {
            child = new FileDisplayTree(false, null, tokens[index]);
            curr.children.put(tokens[index], child);
        }
        FileDisplayTree.add(filePath, child, tokens, index + 1, size);
    }

    private static FileDisplayTree getTree(FileDisplayTree curr, Object[] paths, int index) {
        String toCompare = (String)((AbstractFileNode)paths[index]).getUserObject();
        if (index == paths.length - 1) {
            return curr.path.equals(toCompare) ? curr : null;
        }
        if (curr.path.equals(toCompare)) {
            toCompare = (String)((AbstractFileNode)paths[index + 1]).getUserObject();
            FileDisplayTree child = curr.children.get(toCompare);
            return child == null ? null : FileDisplayTree.getTree(child, paths, index + 1);
        }
        return null;
    }
}

