/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.tree;

import java.awt.Color;
import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class AbstractFileNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -5165045093185370972L;
    private String toolTipText;
    private final String path;

    protected AbstractFileNode(String path, Object contents) {
        super(contents);
        this.path = path;
    }

    public abstract Color getColor();

    public abstract void setColor(Color var1);

    public abstract AbstractFileNode create(String var1, Object var2);

    public abstract boolean excludeFromTree();

    public abstract int getFlagForPath(String var1);

    public String getFilePath() {
        return this.path;
    }

    public String getNodeName() {
        return this.getUserObject().toString();
    }

    public File getNodeFile(boolean flat) {
        if (flat) {
            return this.getFilePath() == null ? null : new File(this.getFilePath());
        }
        return new File(this.getUserObject().toString());
    }

    public String getNodePath() {
        StringBuilder builder = new StringBuilder();
        TreeNode[] path = this.getPath();
        int i = 0;
        while (i < path.length - 1) {
            builder.append(((DefaultMutableTreeNode)path[i]).getUserObject());
            ++i;
        }
        builder.append(((DefaultMutableTreeNode)path[path.length - 1]).getUserObject());
        return builder.toString();
    }

    public File getNodePathAsFile(boolean flat) {
        if (flat) {
            return this.getNodeFile(flat);
        }
        StringBuilder builder = new StringBuilder();
        TreeNode[] path = this.getPath();
        int i = 0;
        while (i < path.length - 1) {
            builder.append(((DefaultMutableTreeNode)path[i]).getUserObject());
            builder.append("/");
            ++i;
        }
        builder.append(((DefaultMutableTreeNode)path[path.length - 1]).getUserObject());
        if (this.getFilePath() == null) {
            builder.append("/");
        }
        return new File(builder.toString());
    }

    protected void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
    }

    protected String getToolTipText() {
        return this.toolTipText;
    }
}

