/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.popup;

import edu.uwyo.crawl.ui.panels.PanelFiles;
import edu.uwyo.crawl.ui.popup.ChangeFlagListener;
import edu.uwyo.crawl.ui.popup.CopyContentsListener;
import edu.uwyo.crawl.ui.popup.CopyNameListener;
import edu.uwyo.crawl.ui.popup.CopyPathListener;
import edu.uwyo.crawl.ui.popup.DuplicateCheckListener;
import edu.uwyo.crawl.ui.popup.ExportListener;
import edu.uwyo.crawl.ui.popup.OpenFileListener;
import edu.uwyo.crawl.ui.popup.OpenFileLocationListener;
import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import edu.uwyo.crawl.ui.tree.AbstractFileNodePopup;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import net.javamon.dev.AbstractFrame;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JAcceleratedPopupMenu;

public class FilePopupMenu
extends AbstractFileNodePopup {
    private static final Color NORMAL = new JMenuItem().getBackground();
    private static Color SELECTED;
    private JAcceleratedPopupMenu menu;
    private JMenuItem copyPath;
    private JMenuItem copyName;
    private JMenuItem copyContents;
    private JMenuItem openFile;
    private JMenuItem openFileLoc;
    private JMenu export;
    private JMenuItem exportAll;
    private JMenuItem exportSub;
    private JMenuItem exportSingle;
    private JMenu duplicateCheck;
    private JMenuItem[] duplicateMode;
    private JMenu flagAs;
    private JMenuItem[] flags;
    private boolean flat;
    private AbstractFileNode[] currNodes;

    public FilePopupMenu() {
        Object o = UIManager.get("MenuItem.selectionBackground");
        SELECTED = o instanceof Color ? (Color)o : NORMAL;
        this.menu = new JAcceleratedPopupMenu();
        this.setCopyPath();
        this.setCopyName();
        this.setCopyContents();
        this.menu.addSeparator();
        this.setOpenFile();
        this.setOpenFileLoc();
        this.menu.addSeparator();
        this.setExport();
        this.setDuplicateCheck();
        this.menu.addSeparator();
        this.setFlagAs();
    }

    @Override
    protected void show(AbstractFileNode[] nodes, boolean flat, MouseEvent e) {
        this.currNodes = nodes;
        this.flat = flat;
        boolean folderOnly = true;
        int i = 0;
        while (i < this.currNodes.length) {
            if (this.currNodes[i].getFilePath() != null) {
                folderOnly = false;
                int currFlag = PanelFiles.indexOf(this.currNodes[i].getColor());
                int j = 0;
                while (j < this.flags.length) {
                    this.flags[j].setBackground(j != currFlag ? NORMAL : SELECTED);
                    this.flags[j].setEnabled(true);
                    ++j;
                }
                break;
            }
            ++i;
        }
        this.copyContents.setEnabled(!folderOnly);
        this.openFile.setEnabled(!folderOnly);
        this.flagAs.setEnabled(!folderOnly);
        if (folderOnly) {
            i = 0;
            while (i < this.flags.length) {
                this.flags[i].setEnabled(false);
                this.flags[i].setBackground(NORMAL);
                ++i;
            }
        }
        this.menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    protected boolean pressKey(AbstractFileNode[] nodes, KeyEvent e) {
        this.currNodes = nodes;
        int i = 0;
        while (i < this.currNodes.length) {
            if (this.currNodes[i].getFilePath() != null) {
                return this.menu.pressKey(e);
            }
            ++i;
        }
        return false;
    }

    protected AbstractFileNode[] currNodes() {
        return this.currNodes;
    }

    protected boolean isFlat() {
        return this.flat;
    }

    private void setCopyPath() {
        this.copyPath = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuCopyPath", new Object[0])));
        this.copyPath.addActionListener(new CopyPathListener(this));
        AbstractFrame.setShortcut(this.copyPath, 67, false, false, true);
        this.menu.addMenuItem(this.copyPath);
    }

    private void setCopyName() {
        this.copyName = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuCopyName", new Object[0])));
        this.copyName.addActionListener(new CopyNameListener(this));
        AbstractFrame.setShortcut(this.copyName, 67, true, false, true);
        this.menu.addMenuItem(this.copyName);
    }

    private void setCopyContents() {
        this.copyContents = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuCopyContents", new Object[0])));
        this.copyContents.addActionListener(new CopyContentsListener(this));
        AbstractFrame.setShortcut(this.copyContents, 67, false, true, true);
        this.menu.addMenuItem(this.copyContents);
    }

    private void setOpenFile() {
        this.openFile = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuOpenFile", new Object[0])));
        this.openFile.addActionListener(new OpenFileListener(this));
        AbstractFrame.setShortcut(this.openFile, 79, false, true, false);
        this.menu.addMenuItem(this.openFile);
    }

    private void setOpenFileLoc() {
        this.openFileLoc = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuOpenFileLoc", new Object[0])));
        this.openFileLoc.addActionListener(new OpenFileLocationListener(this));
        AbstractFrame.setShortcut(this.openFileLoc, 79, true, false, false);
        this.menu.addMenuItem(this.openFileLoc);
    }

    private void setExport() {
        this.export = new JMenu(HTML.wrap(Resources.__("mainPanelFileMenuExport", new Object[0])));
        this.exportAll = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuExportAll", new Object[0])));
        this.exportAll.addActionListener(new ExportListener(this, 0));
        this.export.add(this.exportAll);
        this.exportSub = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuExportSub", new Object[0])));
        this.exportSub.addActionListener(new ExportListener(this, 1));
        this.export.add(this.exportSub);
        this.exportSingle = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuExportSingle", new Object[0])));
        this.exportSingle.addActionListener(new ExportListener(this, 2));
        this.export.add(this.exportSingle);
        this.menu.addMenu(this.export, true);
    }

    private void setDuplicateCheck() {
        this.duplicateCheck = new JMenu(HTML.wrap(Resources.__("mainPanelFileMenuDuplicate", new Object[0])));
        this.duplicateMode = new JMenuItem[5];
        int i = 0;
        while (i < this.duplicateMode.length) {
            this.duplicateMode[i] = new JMenuItem(HTML.wrap(Resources.__("mainPanelFileMenuDuplicate" + i, new Object[0])));
            this.duplicateMode[i].addActionListener(new DuplicateCheckListener(this, i));
            this.duplicateCheck.add(this.duplicateMode[i]);
            ++i;
        }
        this.menu.addMenu(this.duplicateCheck, true);
    }

    private void setFlagAs() {
        this.flagAs = new JMenu(HTML.wrap(Resources.__("mainPanelFileMenuFlagAs", new Object[0])));
        this.flags = new JMenuItem[PanelFiles.getNumFlags()];
        int i = 0;
        while (i < this.flags.length) {
            this.flags[i] = new JMenuItem(HTML.wrap(Resources.__("mainFlag" + i + "NoHTML", new Object[0])));
            this.flags[i].addActionListener(new ChangeFlagListener(this, i));
            if (i != 0) {
                this.flags[i].setAccelerator(PanelFiles.getKeyStroke(i));
                this.flagAs.add(this.flags[i]);
            }
            ++i;
        }
        this.menu.addMenu(this.flagAs, true);
    }
}

