/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.popup;

import edu.uwyo.crawl.ui.popup.FilePopupMenu;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.javamon.dev.ClipboardTools;

public class ExportListener
implements ActionListener {
    public static final int ALL = 0;
    public static final int SUB = 1;
    public static final int SINGLE = 2;
    private final FilePopupMenu menu;
    private final int mode;

    protected ExportListener(FilePopupMenu menu, int mode) {
        this.menu = menu;
        this.mode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder builder = new StringBuilder();
        if (this.mode == 0) {
            String[] paths = this.menu.getTree().getPaths();
            int i = 0;
            while (i < paths.length) {
                builder.append(String.valueOf(paths[i]) + "\n");
                ++i;
            }
        } else if (this.mode == 2) {
            int i = 0;
            while (i < this.menu.currNodes().length) {
                String nodePath = this.menu.currNodes()[i].getFilePath();
                if (nodePath != null) {
                    builder.append(new File(nodePath).getAbsoluteFile() + "\n");
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.menu.currNodes().length) {
                String nodePath = this.menu.currNodes()[i].getFilePath();
                File f = this.menu.currNodes()[i].getNodePathAsFile(this.menu.isFlat());
                if (nodePath != null) {
                    builder.append(new File(nodePath).getAbsoluteFile() + "\n");
                } else if (f != null) {
                    FileDisplayTree tree = this.menu.getTree().getTree(this.menu.currNodes()[i].getPath());
                    String[] paths = tree.getPaths();
                    int j = 0;
                    while (j < paths.length) {
                        builder.append(String.valueOf(paths[j]) + "\n");
                        ++j;
                    }
                }
                ++i;
            }
        }
        ClipboardTools.store(new StringSelection(builder.toString()));
    }
}

