/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.popup;

import edu.uwyo.Main;
import edu.uwyo.crawl.ui.popup.FilePopupMenu;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import net.javamon.dev.Console;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.windowLoad.WindowLoad;

public class DuplicateCheckListener
implements ActionListener {
    protected static final int NAME = 0;
    protected static final int CONTENT = 1;
    protected static final int NAME_CONTENT = 2;
    protected static final int CONTENT_EXACT = 3;
    protected static final int NAME_CONTENT_EXACT = 4;
    protected static final int NUM_MODES = 5;
    private static final WindowLoad.WindowLoadInvokable INVOKABLE = new WindowLoad.WindowLoadInvokable(){

        @Override
        public String getText() {
            return Resources.__("mainNumSearched", Main.database().numSearched());
        }
    };
    private final FilePopupMenu menu;
    private final int mode;

    protected DuplicateCheckListener(FilePopupMenu menu, int mode) {
        this.menu = menu;
        this.mode = mode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.menu.isFlat()) {
            Prompt.error(Resources.__("mainPanelFileMenuDuplicateErrorH", new Object[0]), Resources.__("mainPanelFileMenuDuplicateErrorMsg", new Object[0]));
            return;
        }
        if (this.menu.currNodes().length == 1 && this.menu.currNodes()[0].getFilePath() != null) {
            Prompt.error(Resources.__("mainPanelFileMenuDuplicateErrorH", new Object[0]), Resources.__("mainPanelFileMenuDuplicateErrorSingleMsg", new Object[0]));
            return;
        }
        int choice = Prompt.show(Resources.__("mainPanelFileMenuDuplicateConfirmH", new Object[0]), Resources.__("mainPanelFileMenuDuplicateConfirmMsg", new Object[0]));
        if (choice != 0) {
            return;
        }
        Main.frameMain.hide();
        Main.allowWindowKill(true);
        Console.windowLoad.start(null, INVOKABLE);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayList paths = new ArrayList();
                ArrayList sizes = new ArrayList();
                DuplicateCheckListener.this.getPathAndSize(paths, sizes);
                String[] pathsArray = paths.toArray(new String[paths.size()]);
                long[] sizesArray = DuplicateCheckListener.this.convertLong(sizes);
                String root = DuplicateCheckListener.this.menu.getTree().getFilePath();
                boolean names = DuplicateCheckListener.this.mode == 0 || DuplicateCheckListener.this.mode == 2 || DuplicateCheckListener.this.mode == 4;
                boolean content = DuplicateCheckListener.this.mode == 1 || DuplicateCheckListener.this.mode == 2 || DuplicateCheckListener.this.mode == 3 || DuplicateCheckListener.this.mode == 4;
                boolean exact = DuplicateCheckListener.this.mode == 3 || DuplicateCheckListener.this.mode == 4;
                FileDisplayTree resultTree = Main.query().runDuplicates(Main.database(), pathsArray, sizesArray, root, names, content, exact);
                Main.frameMain.main().list.updateView(resultTree);
                Console.windowLoad.stop();
                Main.frameMain.modify();
                Main.frameMain.show(Main.currSnapshot());
                Main.allowWindowKill(false);
            }
        }).start();
    }

    private void getPathAndSize(ArrayList<String> paths, ArrayList<Long> sizes) {
        int i = 0;
        while (i < this.menu.currNodes().length) {
            FileDisplayTree tree;
            String nodePath = this.menu.currNodes()[i].getFilePath();
            File f = this.menu.currNodes()[i].getNodePathAsFile(this.menu.isFlat());
            if (nodePath != null) {
                tree = this.menu.getTree().getTree(this.menu.currNodes()[i].getPath());
                paths.add(tree.getFilePath());
                sizes.add(tree.getFileSize());
            } else if (f != null) {
                tree = this.menu.getTree().getTree(this.menu.currNodes()[i].getPath());
                String[] stringArray = tree.getPaths();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    paths.add(path);
                    ++n2;
                }
                long[] lArray = tree.getPathSizes();
                int n3 = lArray.length;
                n = 0;
                while (n < n3) {
                    long size = lArray[n];
                    sizes.add(size);
                    ++n;
                }
            }
            ++i;
        }
    }

    private long[] convertLong(ArrayList<Long> array) {
        long[] toReturn = new long[array.size()];
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = array.get(i);
            ++i;
        }
        return toReturn;
    }
}

