/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.popup;

import edu.uwyo.Main;
import edu.uwyo.crawl.ui.panels.PanelFiles;
import edu.uwyo.crawl.ui.tree.AbstractFileNode;
import java.awt.Color;

public class ColorHashFileNode
extends AbstractFileNode {
    private static final long serialVersionUID = -3368228857693840499L;

    public ColorHashFileNode(String path, Object contents) {
        super(path, contents);
    }

    @Override
    public Color getColor() {
        return PanelFiles.getFlagColor(this.getFlagForPath(this.getFilePath()));
    }

    @Override
    public void setColor(Color color) {
        if (this.getFilePath() != null) {
            if (color == null) {
                Main.removeFlag(this.getFilePath());
                return;
            }
            byte chosenFlag = (byte)PanelFiles.indexOf(color);
            if (chosenFlag != -1) {
                Main.setFlag(this.getFilePath(), chosenFlag);
            }
        }
    }

    @Override
    public ColorHashFileNode create(String path, Object contents) {
        return new ColorHashFileNode(path, contents);
    }

    @Override
    public boolean excludeFromTree() {
        if (this.getFilePath() != null) {
            int index;
            Color color = this.getColor();
            int n = index = color == null ? 0 : PanelFiles.indexOf(color);
            if (index != -1 && !Main.frameMain.flags().main().flags[index].enabled.isSelected()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getFlagForPath(String filePath) {
        int setFlag;
        if (filePath == null) {
            return -1;
        }
        int sizeFlag = Main.query().getSizeDescriptor(filePath);
        Byte flag = Main.getFlag(filePath);
        int n = setFlag = flag == null ? -1 : (int)flag.byteValue();
        if (setFlag == -1 && sizeFlag == 0) {
            return -1;
        }
        if (setFlag == -1) {
            switch (sizeFlag) {
                case 2: {
                    return 5;
                }
                case 1: {
                    return 4;
                }
            }
            return -1;
        }
        return setFlag;
    }
}

