/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.panels.PanelMain;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;
import net.javamon.dev.utils.layout.ValidateListener;

public class PanelTime
extends AbstractPanel
implements RestorableView {
    public static final int OLDER = 0;
    public static final int NEWER = 1;
    public static final int BETWEEN = 2;
    public static final int CREATED = 0;
    public static final int MODIFIED = 1;
    public static final int ACCESSED = 2;
    public static final int NUM_MODES = 3;
    private static final String DELIMITERS = "[/ :\\-.]+";
    private static final String DATE_FORMAT_STRING = "MM/dd/yyyy HH:mm";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm");
    private static final String DEFAULT_YEAR_PREFIX = "20";
    public JCheckBox enabled;
    public ExtendableJComboBox<String> comparison;
    public JTextField dateMin;
    public JTextField dateMax;
    public final int mode;

    public PanelTime(PanelMain parent, int mode) {
        super("mainPanelOptionsTimeBdr" + mode, 230, 82, new Object[0]);
        this.mode = mode;
        this.setEnabled(parent);
        this.setComparison(parent);
        this.setDateMin(parent);
        this.setDateMax(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.setEnabled(enabled);
        this.comparison.setEnabled(enabled);
        this.dateMin.setEnabled(enabled);
        this.dateMax.setEnabled(enabled);
    }

    @Override
    public void validate() {
        if (!this.enabled.isEnabled()) {
            this.enabled.setSelected(false);
            this.comparison.setSelectedIndex(0);
            this.dateMin.setText("");
            this.dateMax.setText("");
            return;
        }
        boolean isEnabled = this.enabled.isSelected();
        this.comparison.setEnabled(isEnabled);
        this.dateMin.setEnabled(isEnabled && this.comparison.getSelectedIndex() == 2 && this.comparison.isEnabled());
        this.dateMax.setEnabled(isEnabled);
        if (!isEnabled) {
            this.dateMin.setText("");
            this.dateMax.setText("");
            return;
        }
        this.dateMin.setVisible(this.comparison.getSelectedIndex() == 2 && this.comparison.isEnabled());
        this.validateDate(this.dateMax);
        if (this.dateMin.isVisible()) {
            this.validateDate(this.dateMin);
            try {
                Date d1 = DATE_FORMAT.parse(this.dateMin.getText());
                Date d2 = DATE_FORMAT.parse(this.dateMax.getText());
                if (d2.getTime() <= d1.getTime()) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(d1);
                    c.add(12, 1);
                    this.dateMax.setText(DATE_FORMAT.format(c.getTime()));
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public void restoreView() {
        long dateTime;
        String time = this.settingPrefix();
        if (time == null) {
            return;
        }
        String lastEnabled = Main.readSetting(String.valueOf(time) + "Enabled");
        String lastComparison = Main.readSetting(String.valueOf(time) + "Comparison");
        String lastDateMin = Main.readSetting(String.valueOf(time) + "DateMin");
        String lastDateMax = Main.readSetting(String.valueOf(time) + "DateMax");
        if (lastEnabled != null) {
            this.enabled.setSelected(Boolean.parseBoolean(lastEnabled));
        }
        if (lastComparison != null) {
            this.comparison.setSelectedIndex(Integer.parseInt(lastComparison));
        }
        if (lastDateMin != null) {
            dateTime = Long.parseLong(lastDateMin);
            if (dateTime > 0L) {
                this.dateMin.setText(DATE_FORMAT.format(new Date(dateTime)));
            } else {
                this.dateMin.setText("");
            }
        }
        if (lastDateMax != null) {
            dateTime = Long.parseLong(lastDateMax);
            if (dateTime > 0L) {
                this.dateMax.setText(DATE_FORMAT.format(new Date(dateTime)));
            } else {
                this.dateMax.setText("");
            }
        }
    }

    @Override
    public void saveView() {
        String time = this.settingPrefix();
        if (time == null) {
            return;
        }
        Main.writeSetting(String.valueOf(time) + "Enabled", this.enabled.isSelected() ? "True" : "False");
        Main.writeSetting(String.valueOf(time) + "Comparison", String.valueOf(this.comparison.getSelectedIndex()));
        Main.writeSetting(String.valueOf(time) + "DateMin", String.valueOf(this.getTime(this.dateMin)));
        Main.writeSetting(String.valueOf(time) + "DateMax", String.valueOf(this.getTime(this.dateMax)));
    }

    public long getTime(JTextField date) {
        try {
            return DATE_FORMAT.parse(date.getText()).getTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String settingPrefix() {
        switch (this.mode) {
            case 0: {
                return "lastTimeCreated";
            }
            case 1: {
                return "lastTimeModified";
            }
            case 2: {
                return "lastTimeAccessed";
            }
        }
        return null;
    }

    private void validateDate(JTextField date) {
        if (date.isEnabled() && date.getText().length() == 0) {
            date.setText("00/00/0000 00:00");
            return;
        }
        String rawText = date.getText();
        String[] leadingZeroTokens = rawText.split(DELIMITERS);
        if (leadingZeroTokens.length > 1) {
            StringBuilder replaceLeadingZeros = new StringBuilder();
            int i = 0;
            while (i < leadingZeroTokens.length) {
                if (i == 2) {
                    if (leadingZeroTokens[i].length() == 2) {
                        replaceLeadingZeros.append(DEFAULT_YEAR_PREFIX);
                    }
                } else if (leadingZeroTokens[i].length() == 1) {
                    replaceLeadingZeros.append("0");
                }
                replaceLeadingZeros.append(leadingZeroTokens[i]);
                ++i;
            }
            rawText = replaceLeadingZeros.toString();
        }
        String toFormat = rawText.replaceAll(DELIMITERS, "");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < DATE_FORMAT_STRING.length()) {
            if (builder.length() == 2 || builder.length() == 5) {
                builder.append("/");
            } else if (builder.length() == 10) {
                builder.append(" ");
            } else if (builder.length() == 13) {
                builder.append(":");
            }
            if (i < toFormat.length()) {
                builder.append(toFormat.charAt(i));
            } else {
                builder.append("0");
            }
            if (builder.length() == DATE_FORMAT_STRING.length()) break;
            ++i;
        }
        String dateText = builder.toString();
        try {
            DATE_FORMAT.parse(dateText);
            date.setText(dateText);
        }
        catch (ParseException e) {
            Date recoveryDate = new Date();
            recoveryDate.setTime(0L);
            date.setText(DATE_FORMAT.format(recoveryDate));
        }
        try {
            Date resolvedDate = new Date();
            resolvedDate.setTime(DATE_FORMAT.parse(date.getText()).getTime());
            date.setText(DATE_FORMAT.format(resolvedDate));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setEnabled(PanelMain parent) {
        JLabelHTML label = this.createLabel("mainPanelOptionsTimeEnabled", "mainPanelOptionsTimeEnabledTT");
        this.layout("West", label, 5, "West", this.panel);
        this.layout("North", label, 5, "North", this.panel);
        this.add(label);
        this.enabled = this.createCheckBox("mainPanelOptionsTimeEnabledTT", false);
        this.enabled.addActionListener(new ValidateListener(parent));
        this.layout("West", this.enabled, 5, "East", label);
        this.layout("North", this.enabled, 5, "North", this.panel);
        this.add(this.enabled);
    }

    private void setComparison(PanelMain parent) {
        this.comparison = this.createComboBox("mainPanelOptionsTimeCompareTT", Resources.__("mainPanelOptionsTimeCompare0", new Object[0]), Resources.__("mainPanelOptionsTimeCompare1", new Object[0]), Resources.__("mainPanelOptionsTimeCompare2", new Object[0]));
        this.comparison.addActionListener(new ValidateListener(parent));
        this.layout("East", this.comparison, -5, "East", this.panel);
        this.layout("North", this.comparison, 5, "North", this.panel);
        this.add(this.comparison);
    }

    private void setDateMin(PanelMain parent) {
        this.dateMin = this.createTextField(null, 9, "mainPanelOptionsTimeDateTT");
        this.dateMin.addFocusListener(new ValidateFocusListener(parent));
        this.dateMin.addKeyListener(new ValidateKeyListener(parent));
        this.dateMin.setVisible(false);
        this.layout("West", this.dateMin, 5, "West", this.panel);
        this.layout("North", this.dateMin, 5, "South", this.comparison);
        this.add(this.dateMin);
    }

    private void setDateMax(PanelMain parent) {
        this.dateMax = this.createTextField(null, 9, "mainPanelOptionsTimeDateTT");
        this.dateMax.addFocusListener(new ValidateFocusListener(parent));
        this.dateMax.addKeyListener(new ValidateKeyListener(parent));
        this.layout("East", this.dateMax, -5, "East", this.panel);
        this.layout("North", this.dateMax, 5, "South", this.comparison);
        this.add(this.dateMax);
    }
}

