/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.panels.PanelMain;
import javax.swing.JTextField;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.Validate;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;
import net.javamon.dev.utils.layout.ValidateListener;

public class PanelOptionsSize
extends AbstractPanel
implements RestorableView {
    public static final int NONE = 0;
    public static final int SMALLER = 1;
    public static final int LARGER = 2;
    public static final int BETWEEN = 3;
    public ExtendableJComboBox<String> mode;
    public JTextField warning;
    public ExtendableJComboBox<String> warningUnits;
    public JTextField error;
    public ExtendableJComboBox<String> errorUnits;
    private JLabelHTML warningLabel;
    private JLabelHTML errorLabel;

    public PanelOptionsSize(PanelMain parent) {
        super("mainPanelOptionsSizeBdr", 230, 118, new Object[0]);
        this.setMode(parent);
        this.setWarning(parent);
        this.setError(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mode.setEnabled(enabled);
        this.warning.setEnabled(enabled);
        this.warningUnits.setEnabled(enabled);
        this.error.setEnabled(enabled);
        this.errorUnits.setEnabled(enabled);
    }

    @Override
    public void validate() {
        if (!this.mode.isEnabled()) {
            this.mode.setSelectedIndex(0);
            this.warning.setText("");
            this.error.setText("");
            this.warningUnits.setSelectedIndex(0);
            this.errorUnits.setSelectedIndex(0);
            return;
        }
        this.warning.setEnabled(this.mode.getSelectedIndex() != 0);
        this.error.setEnabled(this.mode.getSelectedIndex() != 0);
        this.warningUnits.setEnabled(this.mode.getSelectedIndex() != 0);
        this.errorUnits.setEnabled(this.mode.getSelectedIndex() != 0);
        if (this.mode.getSelectedIndex() == 0) {
            this.warning.setText("");
            this.error.setText("");
            this.warningUnits.setSelectedIndex(0);
            this.errorUnits.setSelectedIndex(0);
        }
        Validate.textConstrainInt(this.warning, 1, false);
        Validate.textConstrainInt(this.error, 1, false);
        int warningNum = Integer.parseInt(this.warning.getText());
        int warningSize = this.warningUnits.getSelectedIndex();
        int errorNum = Integer.parseInt(this.error.getText());
        int errorSize = this.errorUnits.getSelectedIndex();
        int warningAmount = this.getAmount(warningNum, warningSize);
        int errorAmount = this.getAmount(errorNum, errorSize);
        if (this.mode.getSelectedIndex() == 2 && errorAmount <= warningAmount) {
            this.error.setText(String.valueOf(warningNum + 1));
            this.errorUnits.setSelectedIndex(warningSize);
        } else if (this.mode.getSelectedIndex() == 1 && errorAmount >= warningAmount) {
            if (warningNum > 1) {
                this.error.setText(String.valueOf(warningNum - 1));
            } else if (warningSize > 0) {
                this.error.setText("1023");
                this.errorUnits.setSelectedIndex(warningSize - 1);
            } else {
                this.warning.setText(String.valueOf(errorNum + 1));
                this.warningUnits.setSelectedIndex(errorSize);
            }
        } else if (this.mode.getSelectedIndex() == 3 && errorAmount < warningAmount) {
            this.error.setText(String.valueOf(warningNum + 1));
            this.errorUnits.setSelectedIndex(warningSize);
        }
        if (this.mode.getSelectedIndex() == 3) {
            this.warningLabel.setText(HTML.wrap(Resources.__("mainPanelOptionsSizeMin", new Object[0])));
            this.warningLabel.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMinTT", new Object[0])));
            this.warningUnits.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMinTT", new Object[0])));
            this.warning.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMinTT", new Object[0])));
            this.errorLabel.setText(HTML.wrap(Resources.__("mainPanelOptionsSizeMax", new Object[0])));
            this.errorLabel.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMaxTT", new Object[0])));
            this.errorUnits.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMaxTT", new Object[0])));
            this.error.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeMaxTT", new Object[0])));
        } else {
            this.warningLabel.setText(HTML.wrap(Resources.__("mainPanelOptionsSizeWarning", new Object[0])));
            this.warningLabel.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeWarningTT", new Object[0])));
            this.warningUnits.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeWarningTT", new Object[0])));
            this.warning.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeWarningTT", new Object[0])));
            this.errorLabel.setText(HTML.wrap(Resources.__("mainPanelOptionsSizeError", new Object[0])));
            this.errorLabel.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeErrorTT", new Object[0])));
            this.errorUnits.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeErrorTT", new Object[0])));
            this.error.setToolTipText(HTML.wrap(Resources.__("mainPanelOptionsSizeErrorTT", new Object[0])));
        }
    }

    @Override
    public void restoreView() {
        String lastMode = Main.readSetting("lastSizeMode");
        String lastWarning = Main.readSetting("lastSizeWarning");
        String lastWarningUnits = Main.readSetting("lastSizeWarningUnits");
        String lastError = Main.readSetting("lastSizeError");
        String lastErrorUnits = Main.readSetting("lastSizeErrorUnits");
        if (lastMode != null) {
            this.mode.setSelectedIndex(Integer.parseInt(lastMode));
        }
        if (lastWarning != null) {
            this.warning.setText(lastWarning);
        }
        if (lastWarningUnits != null) {
            this.warningUnits.setSelectedIndex(Integer.parseInt(lastWarningUnits));
        }
        if (lastError != null) {
            this.error.setText(lastError);
        }
        if (lastErrorUnits != null) {
            this.errorUnits.setSelectedIndex(Integer.parseInt(lastErrorUnits));
        }
    }

    @Override
    public void saveView() {
        Main.writeSetting("lastSizeMode", String.valueOf(this.mode.getSelectedIndex()));
        Main.writeSetting("lastSizeWarning", this.warning.getText());
        Main.writeSetting("lastSizeWarningUnits", String.valueOf(this.warningUnits.getSelectedIndex()));
        Main.writeSetting("lastSizeError", this.error.getText());
        Main.writeSetting("lastSizeErrorUnits", String.valueOf(this.errorUnits.getSelectedIndex()));
    }

    public long getWarningBytes() {
        return (long)this.getAmount(Integer.parseInt(this.warning.getText()), this.warningUnits.getSelectedIndex()) * 1024L;
    }

    public long getErrorBytes() {
        return (long)this.getAmount(Integer.parseInt(this.error.getText()), this.errorUnits.getSelectedIndex()) * 1024L;
    }

    private int getAmount(int amount, int unitIndex) {
        switch (unitIndex) {
            case 1: {
                return amount * 1024;
            }
            case 2: {
                return amount * 1024 * 1024;
            }
        }
        return amount;
    }

    private void setMode(PanelMain parent) {
        JLabelHTML label = this.createLabel("mainPanelOptionsSizeMode", "mainPanelOptionsSizeModeTT");
        this.layout("West", label, 5, "West", this.panel);
        this.layout("North", label, 5, "North", this.panel);
        this.add(label);
        this.mode = this.createComboBox("mainPanelOptionsSizeModeTT", Resources.__("mainPanelOptionsSizeMode0", new Object[0]), Resources.__("mainPanelOptionsSizeMode1", new Object[0]), Resources.__("mainPanelOptionsSizeMode2", new Object[0]), Resources.__("mainPanelOptionsSizeMode3", new Object[0]));
        this.mode.addActionListener(new ValidateListener(parent));
        this.layout("East", this.mode, -5, "East", this.panel);
        this.layout("North", this.mode, 5, "North", this.panel);
        this.add(this.mode);
    }

    private void setWarning(PanelMain parent) {
        this.warningLabel = this.createLabel("mainPanelOptionsSizeWarning", "mainPanelOptionsSizeWarningTT", 100);
        this.layout("West", this.warningLabel, 5, "West", this.panel);
        this.layout("North", this.warningLabel, 5, "South", this.mode);
        this.add(this.warningLabel);
        this.warningUnits = this.createUnits(parent, "mainPanelOptionsSizeWarningTT");
        this.layout("East", this.warningUnits, -5, "East", this.panel);
        this.layout("North", this.warningUnits, 5, "South", this.mode);
        this.add(this.warningUnits);
        this.warning = this.createTextField(null, 5, "mainPanelOptionsSizeWarningTT");
        this.warning.addFocusListener(new ValidateFocusListener(parent));
        this.warning.addKeyListener(new ValidateKeyListener(parent));
        this.layout("East", this.warning, -5, "West", this.warningUnits);
        this.layout("North", this.warning, 5, "South", this.mode);
        this.add(this.warning);
    }

    private void setError(PanelMain parent) {
        this.errorLabel = this.createLabel("mainPanelOptionsSizeError", "mainPanelOptionsSizeErrorTT", 100);
        this.layout("West", this.errorLabel, 5, "West", this.panel);
        this.layout("North", this.errorLabel, 5, "South", this.warningUnits);
        this.add(this.errorLabel);
        this.errorUnits = this.createUnits(parent, "mainPanelOptionsSizeErrorTT");
        this.layout("East", this.errorUnits, -5, "East", this.panel);
        this.layout("North", this.errorUnits, 5, "South", this.warningUnits);
        this.add(this.errorUnits);
        this.error = this.createTextField(null, 5, "mainPanelOptionsSizeErrorTT");
        this.error.addFocusListener(new ValidateFocusListener(parent));
        this.error.addKeyListener(new ValidateKeyListener(parent));
        this.layout("East", this.error, -5, "West", this.errorUnits);
        this.layout("North", this.error, 5, "South", this.warningUnits);
        this.add(this.error);
    }

    private ExtendableJComboBox<String> createUnits(PanelMain parent, String tooltipKey) {
        ExtendableJComboBox<String> units = this.createComboBox(tooltipKey, Resources.__("mainPanelOptionsSizeKB", new Object[0]), Resources.__("mainPanelOptionsSizeMB", new Object[0]), Resources.__("mainPanelOptionsSizeGB", new Object[0]));
        units.addActionListener(new ValidateListener(parent));
        return units;
    }
}

