/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.panels.PanelMain;
import net.javamon.dev.utils.JScrollPaneText;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;

public class PanelOptionsFiles
extends AbstractPanel
implements RestorableView {
    public static final String DELIMITERS = "[ \t\n,]+";
    public static final String ALL_FILES = "*";
    public JScrollPaneText fileTypes;

    public PanelOptionsFiles(PanelMain parent) {
        super("mainPanelOptionsFilesBdr", 230, 75, new Object[0]);
        this.setTypes(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.fileTypes.setEnabled(enabled);
    }

    @Override
    public void validate() {
        String text = this.fileTypes.getText();
        if (text.length() == 0) {
            this.fileTypes.setText(ALL_FILES);
            return;
        }
        String[] types = text.split(DELIMITERS);
        StringBuilder validated = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            if (types[i].contains(ALL_FILES)) {
                this.fileTypes.setText(ALL_FILES);
                return;
            }
            String validatedType = "." + types[i].replace(".", "");
            validated.append(String.valueOf(validatedType) + " ");
            ++i;
        }
        this.fileTypes.setText(validated.toString());
    }

    @Override
    public void restoreView() {
        String lastFiles = Main.readSetting("lastFileTypes");
        if (lastFiles != null) {
            this.fileTypes.setText(lastFiles);
        }
    }

    @Override
    public void saveView() {
        Main.writeSetting("lastFileTypes", this.fileTypes.getText());
    }

    public String[] getValidTypes() {
        String text = this.fileTypes.getText();
        if (text.equals(ALL_FILES)) {
            return null;
        }
        return text.split(DELIMITERS);
    }

    private void setTypes(PanelMain parent) {
        this.fileTypes = this.createScrollText(0, null, "mainPanelOptionsFilesTT", 4, 5, true, true, false, true, this.borderWidth() - this.left() - this.right(), this.borderHeight() - this.top() - this.bottom());
        this.fileTypes.setText(ALL_FILES);
        this.fileTypes.getPane().addFocusListener(new ValidateFocusListener(parent));
        this.fileTypes.getPane().addKeyListener(new ValidateKeyListener(parent));
        this.layoutFill(this.fileTypes, 5, this.panel, this.panel, this.panel, this.panel);
        this.add(this.fileTypes);
    }
}

