/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.panels.ChooseFolderListener;
import edu.uwyo.crawl.ui.panels.ProcessListener;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.RelativeFileChooser;
import net.javamon.dev.utils.comboBox.ExtendableJComboBox;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;
import net.javamon.dev.utils.layout.ValidateListener;

public class PanelOptions
extends AbstractPanel
implements RestorableView {
    public static final int RECURSE_FILE = 0;
    public static final int RECURSE_INFINITE = 7;
    public static final int RECURSE_RESULTS = 8;
    public static final int NO_DUPLICATE = 0;
    public static final int DUPLICATE_NAME = 1;
    public static final int DUPLICATE_CONTENT = 2;
    public static final int DUPLICATE_ALL = 3;
    private static final Color BAD_PATTERN = new Color(255, 200, 200);
    private static final Color GOOD_PATTERN = new JTextField("").getBackground();
    public JTextField folder;
    public JButton chooseFolder;
    public ExtendableJComboBox<String> recurse;
    public JTextField patternName;
    public JTextField patternContent;
    public JButton process;
    public ExtendableJComboBox<String> duplicate;
    public JCheckBox duplicateExact;
    private JLabelHTML badPattern;
    private RelativeFileChooser fileChooser;

    public PanelOptions() {
        super("mainPanelOptionsBdr", 100, 175, new Object[0]);
        this.setFolder();
        this.setRecurse();
        this.setPatternName();
        this.setPatternContent();
        this.setProcess();
        this.setDuplicate();
        this.setDuplicateExact();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.folder.setEnabled(enabled);
        this.chooseFolder.setEnabled(enabled);
        this.recurse.setEnabled(enabled);
        this.patternName.setEnabled(enabled);
        this.patternContent.setEnabled(enabled);
        this.process.setEnabled(enabled);
        this.duplicate.setEnabled(enabled);
        this.duplicateExact.setEnabled(enabled);
    }

    @Override
    public void validate() {
        int mode;
        boolean correctFile;
        this.validatePattern(this.patternName, this.badPattern);
        if (this.badPattern.isVisible()) {
            this.validatePattern(this.patternContent, null);
        } else {
            this.validatePattern(this.patternContent, this.badPattern);
        }
        int nesting = this.recurse.getSelectedIndex();
        if (nesting == 8 && Main.frameMain != null && Main.frameMain.main().list.tree.getTree() == null) {
            this.recurse.setSelectedIndex(0);
            nesting = 0;
        }
        boolean isFile = new File(this.folder.getText()).isFile();
        boolean bl = correctFile = nesting == 0 && isFile || nesting != 0 && !isFile;
        if (!correctFile) {
            this.folder.setText("");
        }
        this.duplicateExact.setEnabled((mode = this.duplicate.getSelectedIndex()) == 2 || mode == 3);
        if (mode != 2 && mode != 3) {
            this.duplicateExact.setSelected(false);
        }
        this.process.setEnabled(!this.badPattern.isVisible() && this.folder.getText().length() > 0 && correctFile);
    }

    @Override
    public void restoreView() {
        String lastFolder = Main.readSetting("lastFolder");
        String lastPatternName = Main.readSetting("lastPatternName");
        String lastPatternContent = Main.readSetting("lastPatternContent");
        String lastRecurse = Main.readSetting("lastRecurse");
        String lastDuplicate = Main.readSetting("lastDuplicate");
        String lastDuplicateExact = Main.readSetting("lastDuplicateExact");
        if (lastFolder != null) {
            this.folder.setText(lastFolder);
            this.folder.getCaret().setDot(this.folder.getText().length());
        }
        if (lastPatternName != null) {
            this.patternName.setText(lastPatternName);
        }
        if (lastPatternContent != null) {
            this.patternContent.setText(lastPatternContent);
        }
        if (lastRecurse != null) {
            this.recurse.setSelectedIndex(Integer.parseInt(lastRecurse));
        }
        if (lastDuplicate != null) {
            this.duplicate.setSelectedIndex(Integer.parseInt(lastDuplicate));
        }
        if (lastDuplicateExact != null) {
            this.duplicateExact.setEnabled(Boolean.parseBoolean(lastDuplicateExact));
        }
    }

    @Override
    public void saveView() {
        Main.writeSetting("lastFolder", this.folder.getText());
        Main.writeSetting("lastPatternName", this.patternName.getText());
        Main.writeSetting("lastPatternContent", this.patternContent.getText());
        Main.writeSetting("lastRecurse", String.valueOf(this.recurse.getSelectedIndex()));
        Main.writeSetting("lastDuplicate", String.valueOf(this.duplicate.getSelectedIndex()));
        Main.writeSetting("lastDuplicateExact", this.duplicateExact.isSelected() ? "True" : "False");
    }

    private void validatePattern(JTextField pattern, JLabelHTML badPattern) {
        pattern.setBackground(GOOD_PATTERN);
        if (badPattern != null) {
            badPattern.setVisible(false);
        }
        if (pattern.isEnabled() && pattern.isEditable()) {
            try {
                Pattern.compile(pattern.getText());
            }
            catch (PatternSyntaxException e) {
                pattern.setBackground(BAD_PATTERN);
                if (badPattern != null) {
                    badPattern.setVisible(true);
                }
            }
        } else {
            pattern.setText("");
        }
    }

    private void setFolder() {
        JLabelHTML label = this.createLabel("mainPanelOptionsChoose", "mainPanelOptionsChooseTT");
        this.layout("West", label, 5, "West", this.panel);
        this.layout("North", label, 5, "North", this.panel);
        this.add(label);
        this.chooseFolder = this.createButton("mainPanelOptionsChooseButton", "mainPanelOptionsChooseTT", -1, -1);
        this.fileChooser = RelativeFileChooser.build("mainPanelOptionsChooseH", -1, 2, null, false);
        this.chooseFolder.addActionListener(new ChooseFolderListener(this, this.fileChooser));
        this.layout("East", this.chooseFolder, -5, "East", this.panel);
        this.layout("North", this.chooseFolder, 5, "North", this.panel);
        this.add(this.chooseFolder);
        this.folder = this.createTextField(null, 40, "mainPanelOptionsChooseTT");
        this.folder.setEditable(false);
        this.layout("West", this.folder, 5, "East", label);
        this.layout("East", this.folder, -5, "West", this.chooseFolder);
        this.layout("North", this.folder, 5, "North", this.panel);
        this.add(this.folder);
    }

    private void setRecurse() {
        this.recurse = this.createComboBox("mainPanelOptionsRecurseTT", HTML.wrap(Resources.__("mainPanelOptionsRecurse0", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse1", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse2", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse3", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse4", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse5", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurse6", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurseAll", new Object[0])), HTML.wrap(Resources.__("mainPanelOptionsRecurseCurr", new Object[0])));
        this.recurse.addActionListener(new ValidateListener(this));
        this.layout("East", this.recurse, -5, "East", this.panel);
        this.layout("North", this.recurse, 5, "South", this.chooseFolder);
        this.add(this.recurse);
        JLabelHTML label = this.createLabel("mainPanelOptionsRecurse", "mainPanelOptionsRecurseTT");
        this.layout("East", label, -5, "West", this.recurse);
        this.layout("North", label, 5, "South", this.chooseFolder);
        this.add(label);
    }

    private void setPatternName() {
        JLabelHTML label = this.createLabel("mainPanelOptionsPatternName", "mainPanelOptionsPatternNameTT");
        this.layout("West", label, 5, "West", this.panel);
        this.layout("North", label, 5, "South", this.recurse);
        this.add(label);
        this.patternName = this.createTextField(null, 50, "mainPanelOptionsPatternNameTT");
        this.patternName.addFocusListener(new ValidateFocusListener(this));
        this.patternName.addKeyListener(new ValidateKeyListener(this));
        this.layout("West", this.patternName, 5, "East", label);
        this.layout("East", this.patternName, -5, "East", this.panel);
        this.layout("North", this.patternName, 5, "South", this.recurse);
        this.add(this.patternName);
        this.badPattern = this.createLabel("mainPanelOptionsPatternBad", null);
        this.badPattern.setForeground(new Color(255, 0, 0));
        this.layout("West", this.badPattern, 5, "West", this.panel);
        this.layout("South", this.badPattern, -5, "North", this.patternName);
        this.add(this.badPattern);
    }

    private void setPatternContent() {
        JLabelHTML label = this.createLabel("mainPanelOptionsPatternContent", "mainPanelOptionsPatternContentTT");
        this.layout("West", label, 5, "West", this.panel);
        this.layout("North", label, 5, "South", this.patternName);
        this.add(label);
        this.patternContent = this.createTextField(null, 50, "mainPanelOptionsPatternContentTT");
        this.patternContent.addFocusListener(new ValidateFocusListener(this));
        this.patternContent.addKeyListener(new ValidateKeyListener(this));
        this.layout("West", this.patternContent, 5, "East", label);
        this.layout("East", this.patternContent, -5, "East", this.panel);
        this.layout("North", this.patternContent, 5, "South", this.patternName);
        this.add(this.patternContent);
    }

    private void setProcess() {
        this.process = this.createButton("mainPanelOptionsProcess", "mainPanelOptionsProcessTT", -1, -1);
        this.process.setPreferredSize(new Dimension(150, this.process.getPreferredSize().height));
        this.process.addActionListener(new ProcessListener());
        this.layout("East", this.process, -5, "East", this.panel);
        this.layout("South", this.process, -5, "South", this.panel);
        this.add(this.process);
    }

    private void setDuplicate() {
        JLabelHTML label = this.createLabel("mainPanelOptionsDuplicate", "mainPanelOptionsDuplicateTT");
        this.layout("West", label, 5, "West", this.panel);
        this.add(label);
        this.duplicate = this.createComboBox("mainPanelOptionsDuplicateTT", Resources.__("mainPanelOptionsDuplicate0", new Object[0]), Resources.__("mainPanelOptionsDuplicate1", new Object[0]), Resources.__("mainPanelOptionsDuplicate2", new Object[0]), Resources.__("mainPanelOptionsDuplicate3", new Object[0]));
        this.duplicate.addActionListener(new ValidateListener(this));
        this.layout("West", this.duplicate, 5, "East", label);
        this.layout("South", this.duplicate, -5, "South", this.panel);
        this.add(this.duplicate);
        this.layout("North", label, 0, "North", this.duplicate);
    }

    private void setDuplicateExact() {
        JLabelHTML label = this.createLabel("mainPanelOptionsDuplicateExact", "mainPanelOptionsDuplicateExactTT");
        this.layout("West", label, 5, "East", this.duplicate);
        this.layout("North", label, 0, "North", this.duplicate);
        this.add(label);
        this.duplicateExact = this.createCheckBox("mainPanelOptionsDuplicateExactTT", false);
        this.layout("West", this.duplicateExact, 5, "East", label);
        this.layout("North", this.duplicateExact, 0, "North", this.duplicate);
        this.add(this.duplicateExact);
    }
}

