/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.popup.ColorHashFileNode;
import edu.uwyo.crawl.ui.popup.FilePopupMenu;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import edu.uwyo.crawl.ui.tree.PanelFileTree;
import java.awt.Color;
import javax.swing.KeyStroke;
import net.javamon.dev.utils.layout.AbstractPanel;

public class PanelFiles
extends AbstractPanel
implements RestorableView {
    public static final ColorHashFileNode NODE_FACTORY = new ColorHashFileNode(null, null);
    public static final byte FLAG_OKAY = 0;
    public static final byte FLAG_IGNORE = 1;
    public static final byte FLAG_FIXED = 2;
    public static final byte FLAG_REVIEW = 3;
    public static final byte FLAG_WARNING = 4;
    public static final byte FLAG_ERROR = 5;
    private static final Color[] COLORS = new Color[]{new Color(255, 255, 255), new Color(200, 200, 200), new Color(150, 150, 255), new Color(255, 150, 255), new Color(255, 150, 85), new Color(255, 100, 100)};
    private static final KeyStroke[] ACCELERATORS;
    public PanelFileTree tree;

    static {
        KeyStroke[] keyStrokeArray = new KeyStroke[6];
        keyStrokeArray[1] = KeyStroke.getKeyStroke(73, 8);
        keyStrokeArray[2] = KeyStroke.getKeyStroke(70, 8);
        keyStrokeArray[3] = KeyStroke.getKeyStroke(82, 8);
        keyStrokeArray[4] = KeyStroke.getKeyStroke(87, 8);
        keyStrokeArray[5] = KeyStroke.getKeyStroke(69, 8);
        ACCELERATORS = keyStrokeArray;
    }

    public PanelFiles() {
        super("mainPanelFilesBdr");
        this.setTree();
        PanelFiles.COLORS[0] = this.tree.getTreeBackground();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }

    @Override
    public void validate() {
        this.tree.validate();
    }

    @Override
    public void restoreView() {
        this.updateView(Main.database().results().resultTree());
    }

    @Override
    public void saveView() {
    }

    public static int indexOf(Color color) {
        if (color != null) {
            int i = 0;
            while (i < COLORS.length) {
                if (COLORS[i].equals(color)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static Color getFlagColor(int flag) {
        if (flag < 0 || flag >= COLORS.length) {
            return null;
        }
        return COLORS[flag];
    }

    public static KeyStroke getKeyStroke(int flag) {
        if (flag < 0 || flag >= ACCELERATORS.length) {
            return null;
        }
        return ACCELERATORS[flag];
    }

    public static int getNumFlags() {
        return COLORS.length;
    }

    public void updateView(FileDisplayTree resultTree) {
        this.tree.updateView(resultTree);
    }

    private void setTree() {
        this.tree = new PanelFileTree(NODE_FACTORY, null, new FilePopupMenu(), false, true, null, 300, 400, new Object[0]);
        this.layoutFill(this.tree.panel, 5, this.panel, this.panel, this.panel, this.panel);
        this.add(this.tree.panel);
    }
}

