/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameJoin.panels;

import edu.uwyo.crawl.ui.frameJoin.panels.AddListener;
import edu.uwyo.crawl.ui.frameJoin.panels.PanelMain;
import edu.uwyo.crawl.ui.frameJoin.panels.RemoveListener;
import edu.uwyo.crawl.ui.frameJoin.panels.SetMasterListener;
import javax.swing.JButton;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.JScrollList;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateListSelectionListener;

public class PanelList
extends AbstractPanel {
    public JScrollList list;
    public JButton setMaster;
    public JButton add;
    public JButton remove;
    private int currMasterIndex = -1;

    public PanelList(PanelMain parent) {
        super("mainJoinListBdr", 300, 250, new Object[0]);
        this.setAdd(parent);
        this.setRemove(parent);
        this.setMaster(parent);
        this.setList(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
        this.setMaster.setEnabled(enabled);
        this.add.setEnabled(enabled);
        this.remove.setEnabled(enabled);
    }

    @Override
    public void validate() {
        int index = this.list.list().getSelectedIndex();
        this.setMaster.setEnabled(index != -1 && index != this.currMasterIndex);
        this.remove.setEnabled(index != -1 && this.list.model().getSize() > 0);
    }

    protected String[] getEntries() {
        String[] toReturn = new String[this.list.model().getSize()];
        int i = 0;
        while (i < toReturn.length) {
            toReturn[i] = this.list.model().getElementAt(i);
            if (i == this.currMasterIndex) {
                toReturn[i] = toReturn[i].substring(0, toReturn[i].length() - 1);
            }
            ++i;
        }
        return toReturn;
    }

    protected int getMasterIndex() {
        return this.currMasterIndex;
    }

    protected void setMasterIndex() {
        this.currMasterIndex = this.list.list().getSelectedIndex();
        String entry = this.list.model().getElementAt(this.currMasterIndex);
        this.list.model().setElementAt(Resources.__("mainJoinListMasterFile", entry), this.currMasterIndex);
    }

    protected void removeMasterIndex() {
        if (this.currMasterIndex != -1) {
            String entry = this.list.model().getElementAt(this.currMasterIndex);
            this.list.model().setElementAt(entry.substring(0, entry.length() - 1), this.currMasterIndex);
        }
        this.currMasterIndex = -1;
    }

    private void setAdd(PanelMain parent) {
        this.add = this.createButton("mainJoinListAdd", "mainJoinListAddTT", -1, -1);
        this.add.addActionListener(new AddListener(parent));
        this.layout("West", this.add, 5, "West", this.panel);
        this.layout("North", this.add, 5, "North", this.panel);
        this.add(this.add);
    }

    private void setRemove(PanelMain parent) {
        this.remove = this.createButton("mainJoinListRemove", "mainJoinListRemoveTT", -1, -1);
        this.remove.addActionListener(new RemoveListener(parent));
        this.layout("West", this.remove, 5, "East", this.add);
        this.layout("North", this.remove, 5, "North", this.panel);
        this.add(this.remove);
    }

    private void setMaster(PanelMain parent) {
        this.setMaster = this.createButton("mainJoinListMaster", "mainJoinListMasterTT", -1, -1);
        this.setMaster.addActionListener(new SetMasterListener(parent));
        this.layout("West", this.setMaster, 25, "East", this.remove);
        this.layout("North", this.setMaster, 5, "North", this.panel);
        this.add(this.setMaster);
    }

    private void setList(PanelMain parent) {
        this.list = this.createList("mainJoinListItemsTT", 0, 0, 100, 100, null, new String[0]);
        this.list.list().addListSelectionListener(new ValidateListSelectionListener(parent));
        this.layoutFill(this.list.panel, 5, this.add, this.panel, this.panel, this.panel);
        this.add(this.list.panel);
    }
}

