/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameJoin.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.ui.frameJoin.panels.PanelMain;
import edu.uwyo.crawl.ui.panels.PanelFiles;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import net.javamon.dev.Console;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.SetUtils;
import net.javamon.dev.StringUtils;

public class JoinListener
implements ActionListener {
    private static final int MODE_UNION = 0;
    private static final int MODE_INTERSECT = 1;
    private static final int MODE_NON_INTERSECT = 2;
    private static final int MODE_TOTAL_INTERSECT = 3;
    private static final int MODE_TOTAL_DIFFERENCE = 4;
    private static final int MODE_SYMMETRIC_DIFFERENCE = 5;
    private static final int MODE_ASYMMETRIC_DIFFERENCE = 6;
    private final PanelMain parent;

    protected JoinListener(PanelMain parent) {
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final File originalSnapshot = Main.currSnapshot();
        final String[] files = this.parent.list.getEntries();
        final boolean[] flags = this.parent.flags.getFlags();
        final int masterIndex = this.parent.list.getMasterIndex();
        final File master = new File(files[masterIndex]);
        final int mode = this.parent.mode.union.isSelected() ? 0 : (this.parent.mode.intersect.isSelected() ? 1 : (this.parent.mode.nonIntersect.isSelected() ? 2 : (this.parent.mode.totalIntersect.isSelected() ? 3 : (this.parent.mode.totalDifference.isSelected() ? 4 : (this.parent.mode.symmetricDifference.isSelected() ? 5 : 6)))));
        Main.frameMain.hide();
        Console.windowLoad.start(null, null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                FileResults[] results = new FileResults[files.length];
                boolean flatMode = false;
                int i = 0;
                while (i < results.length) {
                    if (!Main.database().loadSearchResults(new File(files[i]))) {
                        JoinListener.error("Load", originalSnapshot, files[i]);
                        return;
                    }
                    if (i == 0) {
                        flatMode = Main.database().results().resultTree().isFlat();
                    } else if (Main.database().results().resultTree().isFlat() != flatMode) {
                        JoinListener.error("Flat", originalSnapshot, files[i]);
                        return;
                    }
                    String root = Main.database().results().resultTree().getFilePath();
                    String[] prefixes = Main.database().results().resultTree().getPrefixes();
                    String[] paths = Main.database().results().resultTree().getPaths();
                    long[] sizes = Main.database().results().resultTree().getPathSizes();
                    int[] flags2 = Main.database().results().resultTree().getFlags(PanelFiles.NODE_FACTORY);
                    results[i] = new FileResults(root, prefixes, paths, sizes, flags2);
                    ++i;
                }
                if (!flatMode && !JoinListener.consolidateRoot(results)) {
                    JoinListener.error("Root", originalSnapshot, null);
                    return;
                }
                Main.database().loadSearchResults(master);
                Main.database().results().resultTree().clear(results[masterIndex].root);
                JoinListener.createFileTree(results, masterIndex, flags, mode);
                Console.windowLoad.stop();
                Prompt.message(Resources.__("mainJoinCompleteH", new Object[0]), Resources.__("mainJoinCompleteMsg", new Object[0]));
                Main.frameMain.modify();
                Main.frameMain.show(null);
            }
        }).start();
    }

    private static void error(String error, File originalSnapshot, String path) {
        String header = Resources.__("mainJoinError" + error + "H", new Object[0]);
        String message = path != null ? Resources.__("mainJoinError" + error + "Msg", path) : Resources.__("mainJoinError" + error + "Msg", new Object[0]);
        if (originalSnapshot != null) {
            Main.database().loadSearchResults(originalSnapshot);
        }
        Console.windowLoad.stop();
        Prompt.show(header, message);
        Main.frameMain.show(originalSnapshot);
    }

    private static boolean consolidateRoot(FileResults[] results) {
        String commonRoot;
        String[] roots = new String[results.length];
        int i = 0;
        while (i < roots.length) {
            roots[i] = results[i].root;
            ++i;
        }
        try {
            commonRoot = StringUtils.longestCommonPrefix(roots);
            if (commonRoot.length() == 0) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        boolean sameRoots = true;
        int i2 = 0;
        while (i2 < roots.length) {
            if (roots[i2].length() != commonRoot.length()) {
                sameRoots = false;
                break;
            }
            ++i2;
        }
        if (!sameRoots) {
            while (!commonRoot.endsWith("/") && !commonRoot.endsWith("\\")) {
                if ((commonRoot = commonRoot.substring(0, commonRoot.length() - 1)).length() != 0) continue;
                return false;
            }
            commonRoot = commonRoot.substring(0, commonRoot.length() - 1);
        }
        i2 = 0;
        while (i2 < roots.length) {
            results[i2].root = commonRoot;
            ++i2;
        }
        return true;
    }

    private static void createFileTree(FileResults[] results, int masterIndex, boolean[] flags, int mode) {
        HashSet<String> entries;
        HashSet[] sets = new HashSet[results.length];
        int i = 0;
        while (i < sets.length) {
            sets[i] = new HashSet();
            int j = 0;
            while (j < results[i].paths.length) {
                sets[i].add(results[i].paths[j]);
                ++j;
            }
            ++i;
        }
        switch (mode) {
            case 0: {
                entries = SetUtils.union(sets);
                break;
            }
            case 1: {
                entries = SetUtils.intersect(sets);
                break;
            }
            case 2: {
                entries = SetUtils.nonIntersect(sets);
                break;
            }
            case 3: {
                entries = SetUtils.totalIntersect(sets);
                break;
            }
            case 4: {
                entries = SetUtils.totalDifference(sets);
                break;
            }
            case 5: {
                entries = SetUtils.symmetricDifference(sets);
                break;
            }
            default: {
                entries = SetUtils.asymmetricDifference(sets);
            }
        }
        FileResults toAdd = results[masterIndex];
        int i2 = 0;
        while (i2 < toAdd.paths.length) {
            JoinListener.addToFileTree(toAdd, i2, entries, flags);
            ++i2;
        }
        i2 = 0;
        while (i2 < results.length) {
            if (i2 != masterIndex) {
                toAdd = results[i2];
                int j = 0;
                while (j < toAdd.paths.length) {
                    JoinListener.addToFileTree(toAdd, j, entries, flags);
                    ++j;
                }
            }
            ++i2;
        }
    }

    private static void addToFileTree(FileResults result, int index, HashSet<String> entries, boolean[] flags) {
        if (entries.contains(result.paths[index])) {
            if (!flags[Math.max(0, result.flags[index])]) {
                return;
            }
            Main.database().results().resultTree().add(result.prefixes[index], result.paths[index], false, result.sizes[index]);
            if (result.flags[index] == -1) {
                Main.database().results().removeFlag(result.paths[index]);
            } else {
                Main.database().results().setFlag(result.paths[index], (byte)result.flags[index]);
            }
            entries.remove(result.paths[index]);
        }
    }

    private static class FileResults {
        private String root;
        private final String[] prefixes;
        private final String[] paths;
        private final long[] sizes;
        private final int[] flags;

        private FileResults(String root, String[] prefixes, String[] paths, long[] sizes, int[] flags) {
            this.root = root;
            this.prefixes = prefixes;
            this.paths = paths;
            this.sizes = sizes;
            this.flags = flags;
        }
    }
}

