/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameFlags.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.FrameMain;
import edu.uwyo.crawl.ui.frameFlags.panels.FlagToggleListener;
import edu.uwyo.crawl.ui.panels.PanelFiles;
import javax.swing.JCheckBox;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.PanelColor;
import net.javamon.dev.utils.layout.AbstractPanel;

public class PanelFlag
extends AbstractPanel
implements RestorableView {
    public JCheckBox enabled;
    public JLabelHTML label;
    private PanelColor color;
    private final int flag;

    public PanelFlag(FrameMain parent, int flag) {
        super(300, 25);
        this.flag = flag;
        this.setFlag(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public void validate() {
    }

    @Override
    public void restoreView() {
        String lastFlag = Main.readSetting("lastFlagFilter" + this.flag);
        if (lastFlag != null) {
            this.enabled.setSelected(Boolean.parseBoolean(lastFlag));
        }
    }

    @Override
    public void saveView() {
        Main.writeSetting("lastFlagFilter" + this.flag, this.enabled.isSelected() ? "True" : "False");
    }

    private void setFlag(FrameMain parent) {
        String flagText = Resources.__("mainFlag" + this.flag + "NoHTML", new Object[0]);
        this.enabled = this.createCheckBox(null, true);
        this.enabled.setToolTipText(HTML.wrap(Resources.__("mainFlagToggleTT", flagText)));
        if (parent != null) {
            this.enabled.addActionListener(new FlagToggleListener(parent));
        }
        this.layout("West", this.enabled, 5, "West", this.panel);
        this.layout("North", this.enabled, 5, "North", this.panel);
        this.add(this.enabled);
        this.label = this.createLabel(null, null);
        this.label.setText(HTML.wrap(Resources.__("mainFlagToggle", flagText)));
        this.label.setToolTipText(this.enabled.getToolTipText());
        this.layout("West", this.label, 5, "East", this.enabled);
        this.layout("North", this.label, 5, "North", this.panel);
        this.add(this.label);
        this.color = this.createColorPanel(PanelFiles.getFlagColor(this.flag), 50, 20, 3, "mainFlagColorTT");
        this.layout("East", this.color.panel, -5, "East", this.panel);
        this.layout("North", this.color.panel, 5, "North", this.panel);
        this.add(this.color.panel);
    }
}

