/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameExclude.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import java.awt.Color;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextField;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;

public class PanelRegex
extends AbstractPanel
implements RestorableView {
    private static final Color BAD_PATTERN = new Color(255, 200, 200);
    private static final Color GOOD_PATTERN = new JTextField("").getBackground();
    public JTextField regex;
    public JLabelHTML badPattern;

    public PanelRegex() {
        super("mainExcludeRegexBdr", 200, 75, new Object[0]);
        this.setRegex();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.regex.setEnabled(enabled);
    }

    @Override
    public void validate() {
        this.regex.setBackground(GOOD_PATTERN);
        this.badPattern.setVisible(false);
        if (this.regex.isEnabled() && this.regex.isEditable()) {
            try {
                Pattern.compile(this.regex.getText());
            }
            catch (PatternSyntaxException e) {
                this.regex.setBackground(BAD_PATTERN);
                if (this.badPattern != null) {
                    this.badPattern.setVisible(true);
                }
            }
        } else {
            this.regex.setText("");
        }
        if (this.regex.getText().trim().length() > 0 && !this.badPattern.isVisible()) {
            Main.excludeList().setPattern(Pattern.compile(this.regex.getText()));
        } else {
            Main.excludeList().setPattern(null);
        }
    }

    @Override
    public void restoreView() {
        String pattern = Main.excludeList().getPattern();
        if (pattern != null) {
            this.regex.setText(pattern);
        } else {
            this.regex.setText("");
        }
    }

    @Override
    public void saveView() {
        Main.excludeList().setPattern(null);
        try {
            if (this.regex.getText().trim().length() > 0 && !this.badPattern.isVisible()) {
                Main.excludeList().setPattern(Pattern.compile(this.regex.getText()));
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public Pattern getRegex() {
        return this.regex.getText().length() == 0 ? null : Pattern.compile(this.regex.getText());
    }

    private void setRegex() {
        this.regex = this.createTextField(null, 25, "mainExcludeRegexTT");
        this.regex.addFocusListener(new ValidateFocusListener(this));
        this.regex.addKeyListener(new ValidateKeyListener(this));
        this.layout("West", this.regex, 5, "West", this.panel);
        this.layout("North", this.regex, 5, "North", this.panel);
        this.layout("East", this.regex, -5, "East", this.panel);
        this.add(this.regex);
        this.badPattern = this.createLabel("mainPanelOptionsPatternBad", null);
        this.badPattern.setForeground(new Color(255, 0, 0));
        this.layout("East", this.badPattern, -5, "East", this.panel);
        this.layout("North", this.badPattern, 5, "South", this.regex);
        this.add(this.badPattern);
    }
}

