/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameExclude.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import java.io.File;
import java.io.IOException;
import net.javamon.dev.utils.JScrollPaneText;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;

public class PanelFiles
extends AbstractPanel
implements RestorableView {
    private static final String DELIMITERS = "[\n]+";
    public JScrollPaneText files;

    public PanelFiles() {
        super("mainExcludeFilesBdr", 200, 100, new Object[0]);
        this.setFiles();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.files.setEnabled(enabled);
    }

    @Override
    public void validate() {
        String text = this.files.getText();
        if (text.length() == 0) {
            return;
        }
        String[] files = text.split(DELIMITERS);
        String[] toCheck = new String[files.length];
        StringBuilder validated = new StringBuilder();
        int i = 0;
        while (i < files.length) {
            try {
                String validatedType;
                toCheck[i] = validatedType = new File(files[i]).getCanonicalPath();
                validated.append(String.valueOf(validatedType) + "\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        this.files.setText(validated.toString());
    }

    @Override
    public void restoreView() {
        String[] files = Main.excludeList().getFiles();
        if (files == null) {
            this.files.setText("");
        } else {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < files.length) {
                builder.append(String.valueOf(files[i]) + "\n");
                ++i;
            }
            this.files.setText(builder.toString());
        }
    }

    @Override
    public void saveView() {
        Main.excludeList().setFiles(this.getExcludedFiles());
    }

    public String[] getExcludedFiles() {
        String text = this.files.getText();
        if (text.length() == 0) {
            return null;
        }
        return text.split(DELIMITERS);
    }

    private void setFiles() {
        this.files = this.createScrollText(0, null, "mainExcludeFilesTT", 4, 5, true, false, false, true, this.borderWidth() - this.left() - this.right(), this.borderHeight() - this.top() - this.bottom());
        this.files.getPane().addFocusListener(new ValidateFocusListener(this));
        this.layoutFill(this.files, 5, this.panel, this.panel, this.panel, this.panel);
        this.add(this.files);
    }
}

