/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameExclude.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.frameExclude.panels.ExcludeNonTextListener;
import javax.swing.JButton;
import net.javamon.dev.utils.JScrollPaneText;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;

public class PanelExtensions
extends AbstractPanel
implements RestorableView {
    private static final String DELIMITERS = "[ \t\n,]+";
    public JScrollPaneText fileTypes;
    public JButton excludeNonText;

    public PanelExtensions() {
        super("mainExcludeExtensionsBdr", 200, 125, new Object[0]);
        this.setExclude();
        this.setTypes();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.excludeNonText.setEnabled(enabled);
        this.fileTypes.setEnabled(enabled);
    }

    @Override
    public void validate() {
        String text = this.fileTypes.getText().trim();
        if (text.length() == 0) {
            this.fileTypes.setText("");
            return;
        }
        String[] types = text.split(DELIMITERS);
        String[] toCheck = new String[types.length];
        StringBuilder validated = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            String validatedType;
            toCheck[i] = validatedType = "." + types[i].replace(".", "");
            validated.append(String.valueOf(validatedType) + " ");
            ++i;
        }
        this.fileTypes.setText(validated.toString().trim());
    }

    @Override
    public void restoreView() {
        String[] ext = Main.excludeList().getExt();
        if (ext == null) {
            this.fileTypes.setText("");
        } else {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < ext.length) {
                builder.append(String.valueOf(ext[i]) + " ");
                ++i;
            }
            this.fileTypes.setText(builder.toString());
        }
    }

    @Override
    public void saveView() {
        Main.excludeList().setExt(this.getExcludedTypes());
    }

    public String[] getExcludedTypes() {
        String text = this.fileTypes.getText();
        if (text.length() == 0) {
            return null;
        }
        return text.split(DELIMITERS);
    }

    private void setExclude() {
        this.excludeNonText = this.createButton("mainExcludeNonText", "mainExcludeNonTextTT", -1, -1);
        this.excludeNonText.addActionListener(new ExcludeNonTextListener(this));
        this.layout("East", this.excludeNonText, -5, "East", this.panel);
        this.layout("North", this.excludeNonText, 5, "North", this.panel);
        this.add(this.excludeNonText);
    }

    private void setTypes() {
        this.fileTypes = this.createScrollText(0, null, "mainExcludeExtensionsTT", 4, 5, true, true, false, true, this.borderWidth() - this.left() - this.right(), this.borderHeight() - this.top() - this.bottom());
        this.fileTypes.getPane().addFocusListener(new ValidateFocusListener(this));
        this.fileTypes.getPane().addKeyListener(new ValidateKeyListener(this));
        this.layoutFill(this.fileTypes, 5, this.excludeNonText, this.panel, this.panel, this.panel);
        this.add(this.fileTypes);
    }
}

