/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui.frameDeveloper.panels;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.FrameMain;
import edu.uwyo.crawl.ui.frameDeveloper.panels.ChangeRootListener;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.JLabelHTML;
import net.javamon.dev.utils.layout.AbstractPanel;
import net.javamon.dev.utils.layout.Validate;
import net.javamon.dev.utils.layout.ValidateFocusListener;
import net.javamon.dev.utils.layout.ValidateKeyListener;

public class PanelMain
extends AbstractPanel
implements RestorableView {
    public static final int DEFAULT_BUFFER_LOCAL = 16384;
    public static final int DEFAULT_BUFFER_NET = 0x1000000;
    public static final int DEFAULT_CHUNK_SIZE = 512;
    public static final int DEFAULT_HEADER_SIZE = 1024;
    public JLabelHTML instructions;
    public JTextField bufferLocal;
    public JTextField bufferNet;
    public JTextField chunkSize;
    public JTextField headerSize;
    public JButton changeRoot;

    public PanelMain(FrameMain parent) {
        this.setInstructions();
        this.layoutColumn.start(5, 5, 5, this.panel, (Component)this.instructions, (Component)this.panel);
        this.setBufferLocal();
        this.setBufferNet();
        this.setChunkSize();
        this.setHeaderSize();
        this.layoutColumn.end();
        this.setChangeRoot(parent);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.bufferLocal.setEnabled(enabled);
        this.bufferNet.setEnabled(enabled);
        this.chunkSize.setEnabled(enabled);
        this.headerSize.setEnabled(enabled);
        this.changeRoot.setEnabled(enabled);
    }

    @Override
    public void validate() {
        String developerMode = Resources.readUserSetting("developerMode");
        if (developerMode == null && !Boolean.parseBoolean(developerMode)) {
            return;
        }
        Validate.textConstrainPOT(this.bufferLocal);
        Validate.textConstrainPOT(this.bufferNet);
        Validate.textConstrainInt(this.chunkSize, 1, false);
        Validate.textConstrainInt(this.headerSize, 1, false);
        this.saveView();
        int searchDepth = Main.frameMain.main().options.recurse.getSelectedIndex();
        this.changeRoot.setEnabled(searchDepth != 0 && Main.frameMain.main().list.tree.getTree() != null);
    }

    @Override
    public void restoreView() {
        String lastBufferLocal = Resources.readUserSetting("lastBufferLocal");
        String lastBufferNet = Resources.readUserSetting("lastBufferNet");
        String lastChunkSize = Resources.readUserSetting("lastChunkSize");
        String lastHeaderSize = Resources.readUserSetting("lastHeaderSize");
        if (lastBufferLocal != null) {
            this.bufferLocal.setText(lastBufferLocal);
        } else {
            this.bufferLocal.setText("16384");
        }
        if (lastBufferNet != null) {
            this.bufferNet.setText(lastBufferNet);
        } else {
            this.bufferNet.setText("16777216");
        }
        if (lastChunkSize != null) {
            this.chunkSize.setText(lastChunkSize);
        } else {
            this.chunkSize.setText("512");
        }
        if (lastHeaderSize != null) {
            this.headerSize.setText(lastHeaderSize);
        } else {
            this.headerSize.setText("1024");
        }
    }

    @Override
    public void saveView() {
        Resources.writeUserSetting("lastBufferLocal", this.bufferLocal.getText());
        Resources.writeUserSetting("lastBufferNet", this.bufferNet.getText());
        Resources.writeUserSetting("lastChunkSize", this.chunkSize.getText());
        Resources.writeUserSetting("lastHeaderSize", this.headerSize.getText());
    }

    public int getBufferLocal() {
        try {
            return Integer.parseInt(this.bufferLocal.getText());
        }
        catch (NumberFormatException e) {
            return 16384;
        }
    }

    public int getBufferNet() {
        try {
            return Integer.parseInt(this.bufferNet.getText());
        }
        catch (NumberFormatException e) {
            return 0x1000000;
        }
    }

    public int getChunkSize() {
        try {
            return Integer.parseInt(this.chunkSize.getText()) * 1000000;
        }
        catch (NumberFormatException e) {
            return 512000000;
        }
    }

    public int getHeaderSize() {
        try {
            return Integer.parseInt(this.headerSize.getText());
        }
        catch (NumberFormatException e) {
            return 1024;
        }
    }

    private void setInstructions() {
        this.instructions = this.createLabel("mainDeveloperInstructions", null);
        this.layout("West", this.instructions, 5, "West", this.panel);
        this.layout("North", this.instructions, 5, "North", this.panel);
        this.layout("East", this.instructions, -5, "East", this.panel);
        this.add(this.instructions);
    }

    private void setBufferLocal() {
        JLabelHTML label = this.createLabel("mainDeveloperBufferLocal", "mainDeveloperBufferLocalTT");
        this.bufferLocal = this.createTextField(null, 7, "mainDeveloperBufferLocalTT");
        this.bufferLocal.addFocusListener(new ValidateFocusListener(this));
        this.bufferLocal.addKeyListener(new ValidateKeyListener(this));
        this.layoutColumn.place(label, this.bufferLocal);
    }

    private void setBufferNet() {
        JLabelHTML label = this.createLabel("mainDeveloperBufferNet", "mainDeveloperBufferNetTT");
        this.bufferNet = this.createTextField(null, 7, "mainDeveloperBufferNetTT");
        this.bufferNet.addFocusListener(new ValidateFocusListener(this));
        this.bufferNet.addKeyListener(new ValidateKeyListener(this));
        this.layoutColumn.place(label, this.bufferNet);
    }

    private void setChunkSize() {
        JLabelHTML label = this.createLabel("mainDeveloperChunkSize", "mainDeveloperChunkSizeTT");
        this.chunkSize = this.createTextField(null, 7, "mainDeveloperChunkSizeTT");
        this.chunkSize.addFocusListener(new ValidateFocusListener(this));
        this.chunkSize.addKeyListener(new ValidateKeyListener(this));
        this.layoutColumn.place(label, this.chunkSize);
    }

    private void setHeaderSize() {
        JLabelHTML label = this.createLabel("mainDeveloperHeaderSize", "mainDeveloperHeaderSizeTT");
        this.headerSize = this.createTextField(null, 7, "mainDeveloperHeaderSizeTT");
        this.headerSize.addFocusListener(new ValidateFocusListener(this));
        this.headerSize.addKeyListener(new ValidateKeyListener(this));
        this.layoutColumn.place(label, this.headerSize);
    }

    private void setChangeRoot(FrameMain parent) {
        this.changeRoot = this.createButton("mainDeveloperChangeRoot", "mainDeveloperChangeRootTT", -1, -1);
        this.changeRoot.addActionListener(new ChangeRootListener(parent));
        this.layout("West", this.changeRoot, 5, "West", this.panel);
        this.layout("South", this.changeRoot, -5, "South", this.panel);
        this.add(this.changeRoot);
    }
}

