/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.ui;

import edu.uwyo.Main;
import edu.uwyo.crawl.RestorableView;
import edu.uwyo.crawl.ui.AboutListener;
import edu.uwyo.crawl.ui.ClearListener;
import edu.uwyo.crawl.ui.CloseListener;
import edu.uwyo.crawl.ui.DeveloperListener;
import edu.uwyo.crawl.ui.DeveloperModeListener;
import edu.uwyo.crawl.ui.ExcludeListener;
import edu.uwyo.crawl.ui.JoinListener;
import edu.uwyo.crawl.ui.LoadListener;
import edu.uwyo.crawl.ui.RegexListener;
import edu.uwyo.crawl.ui.SaveListener;
import edu.uwyo.crawl.ui.ToggleListener;
import edu.uwyo.crawl.ui.frameAbout.FrameAbout;
import edu.uwyo.crawl.ui.frameClear.FrameClear;
import edu.uwyo.crawl.ui.frameDeveloper.FrameDeveloper;
import edu.uwyo.crawl.ui.frameExclude.FrameExclude;
import edu.uwyo.crawl.ui.frameFlags.FrameFlags;
import edu.uwyo.crawl.ui.frameJoin.FrameJoin;
import edu.uwyo.crawl.ui.frameRegex.FrameRegex;
import edu.uwyo.crawl.ui.panels.PanelMain;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.javamon.dev.AbstractFrame;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.RelativeFileChooser;
import net.javamon.dev.utils.layout.Validate;

public class FrameMain
implements WindowListener,
RestorableView {
    protected LoadListener loadListener;
    protected SaveListener saveListener;
    protected ClearListener clearListener;
    protected JoinListener joinListener;
    protected CloseListener closeListener;
    protected ToggleListener toggleListener;
    protected ExcludeListener excludeListener;
    protected DeveloperModeListener developerModeListener;
    protected DeveloperListener developerListener;
    protected RegexListener regexListener;
    protected AboutListener aboutListener;
    protected JMenuItem menuClear;
    protected JMenuItem menuFlags;
    protected JMenuItem menuExclude;
    protected JMenuItem menuDeveloperMode;
    protected JMenuItem menuDeveloper;
    protected FrameClear clear;
    protected FrameJoin join;
    protected FrameExclude exclude;
    protected FrameRegex regex;
    protected FrameAbout about;
    protected FrameFlags flags;
    protected FrameDeveloper developer;
    private JMenuItem database;
    private boolean unsaved;
    private RelativeFileChooser fileChooser;
    private PanelMain panelMain;
    private JFrame frame = new JFrame(Resources.__("mainTitleNoHTML", new Object[0]));

    public FrameMain() {
        this.frame.setMinimumSize(new Dimension(620, 699));
        this.frame.setLayout(new GridLayout(0, 1));
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(this);
        this.setMenuListeners();
        this.setMenuItems();
        this.fileChooser = RelativeFileChooser.build("mainChooseSnapshotH", ".find", false);
        this.panelMain = new PanelMain();
        this.frame.add(this.panelMain.panel);
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.clear = new FrameClear(this);
        this.join = new FrameJoin(this);
        this.exclude = new FrameExclude(this);
        this.regex = new FrameRegex(this);
        this.about = new FrameAbout(this);
        this.flags = new FrameFlags(this);
        this.developer = new FrameDeveloper(this);
        Validate.disable();
        this.restoreView();
        Validate.enable();
        this.panelMain.validate();
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        File snapshot = null;
        if (this.unsaved) {
            int choice;
            while ((choice = Prompt.show(Resources.__("mainResultsSaveH", new Object[0]), Resources.__("mainResultsSaveMsg", new Object[0]))) == 0) {
                if (Main.currSnapshot() != null) {
                    this.fileChooser.setCurrentDirectory(Main.currSnapshot());
                }
                if ((choice = this.fileChooser.showSaveDialog(this.frame)) != 0) continue;
                snapshot = this.fileChooser.getSelectedFile();
                String path = snapshot.getAbsolutePath();
                if (!path.endsWith(".find")) {
                    snapshot = new File(String.valueOf(path) + ".find");
                }
                if (!snapshot.exists() || (choice = Prompt.show(Resources.__("mainResultsSaveConfirmH", new Object[0]), Resources.__("mainResultsSaveConfirmMsg", snapshot.getAbsolutePath()))) == 0) break;
                snapshot = null;
            }
            this.save();
        }
        Main.quit(snapshot);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void restoreView() {
        String developerMode = Resources.readUserSetting("developerMode");
        if (developerMode != null) {
            boolean enable = Boolean.parseBoolean(developerMode);
            ((JCheckBoxMenuItem)this.menuDeveloperMode).setSelected(enable);
            Main.database().setDeveloperMode(enable);
            this.menuDeveloper.setVisible(enable);
        }
        this.panelMain.restoreView();
        this.flags.restoreView();
        this.exclude.restoreView();
        this.developer.restoreView();
    }

    @Override
    public void saveView() {
        this.panelMain.saveView();
        this.flags.saveView();
        this.exclude.saveView();
        this.developer.saveView();
    }

    public void show(File currSnapshot) {
        this.frame.setVisible(true);
        this.updateView(currSnapshot);
        Prompt.setMessageComponent(this.frame);
    }

    public void hide() {
        this.frame.setVisible(false);
        this.clear.hide();
        this.join.hide();
        this.exclude.hide();
        this.regex.hide();
        this.about.hide();
        this.flags.hide();
        this.developer.hide();
    }

    public PanelMain main() {
        return this.panelMain;
    }

    public FrameFlags flags() {
        return this.flags;
    }

    public FrameExclude exclude() {
        return this.exclude;
    }

    public FrameDeveloper developer() {
        return this.developer;
    }

    public void validate() {
        this.clear.main().validate();
        this.join.main().validate();
        this.exclude.main().validate();
        this.regex.main().validate();
        this.about.main().validate();
        this.flags.main().validate();
        this.developer.main().validate();
        this.panelMain.validate();
    }

    public void updateView(File currSnapshot) {
        Validate.disable();
        this.restoreView();
        if (currSnapshot != null) {
            try {
                this.database.setText(Resources.__("mainMenuDatabase", currSnapshot.getCanonicalPath()));
            }
            catch (Exception exception) {}
        } else {
            this.database.setText("");
        }
        Validate.enable();
        this.validate();
    }

    public void modify() {
        this.unsaved = true;
        this.frame.setTitle(Resources.__("mainTitleNoHTMLModified", new Object[0]));
    }

    public void save() {
        this.unsaved = false;
        this.frame.setTitle(Resources.__("mainTitleNoHTML", new Object[0]));
    }

    private void setMenuListeners() {
        this.loadListener = new LoadListener(this);
        this.saveListener = new SaveListener(this);
        this.clearListener = new ClearListener(this);
        this.joinListener = new JoinListener(this);
        this.closeListener = new CloseListener(this.frame);
        this.toggleListener = new ToggleListener(this);
        this.excludeListener = new ExcludeListener(this);
        this.developerModeListener = new DeveloperModeListener(this);
        this.developerListener = new DeveloperListener(this);
        this.regexListener = new RegexListener(this);
        this.aboutListener = new AboutListener(this);
    }

    private void setMenuItems() {
        JMenuBar menuBar = new JMenuBar();
        JMenu file = AbstractFrame.createJMenu("mainMenuFile", null, true);
        AbstractFrame.setJMenuItem(file, "mainMenuFileLoad", "mainMenuFileLoadTT", this.loadListener, true, false, 79, false, false, true);
        AbstractFrame.setJMenuItem(file, "mainMenuFileSave", "mainMenuFileSaveTT", this.saveListener, true, false, 83, false, false, true);
        this.menuClear = AbstractFrame.setJMenuItem(file, "mainMenuFileClear", "mainMenuFileClearTT", this.clearListener, true, false, 116, false, false, false);
        AbstractFrame.setJMenuItem(file, "mainMenuFileJoin", "mainMenuFileJoinTT", this.joinListener, true, false, 74, false, false, true);
        AbstractFrame.setJMenuItem(file, "mainMenuFileClose", "mainMenuFileCloseTT", this.closeListener, true, false, 81, false, false, true);
        menuBar.add(file);
        JMenu options = AbstractFrame.createJMenu("mainMenuOptions", null, true);
        this.menuFlags = AbstractFrame.setJMenuItem(options, "mainMenuOptionsToggle", "mainMenuOptionsToggleTT", this.toggleListener, true, false, 84, false, false, true);
        this.menuExclude = AbstractFrame.setJMenuItem(options, "mainMenuOptionsExclude", "mainMenuOptionsExcludeTT", this.excludeListener, true, false, 69, false, false, true);
        this.menuDeveloperMode = AbstractFrame.setJMenuItem(options, "mainMenuOptionsDeveloper", "mainMenuOptionsDeveloperTT", this.developerModeListener, true, true, 123, false, false, false);
        this.menuDeveloper = AbstractFrame.setJMenuItem(options, "mainMenuOptionsDeveloperOpt", "mainMenuOptionsDeveloperOptTT", this.developerListener, true, false, 119, false, false, false);
        AbstractFrame.setJMenuItem(options, "mainMenuOptionsRegex", "mainMenuOptionsRegexTT", this.regexListener, true, false, 114, false, false, false);
        AbstractFrame.setJMenuItem(options, "mainMenuOptionsAbout", "mainMenuOptionsAboutTT", this.aboutListener, true, false, 112, false, false, false);
        menuBar.add(options);
        this.database = AbstractFrame.setJMenuItem(menuBar, "mainMenuDatabaseSlug", null, null, false, false, 0, false, false, false);
        this.frame.setJMenuBar(menuBar);
    }
}

