/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.database.DataInput;
import edu.uwyo.crawl.database.DataOutput;
import edu.uwyo.crawl.database.ExcludeList;
import edu.uwyo.crawl.database.FileSearchControl;
import edu.uwyo.crawl.database.Serializer;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class Results
implements Serializable,
Serializer<Results> {
    public static final Results INSTANCE = new Results();
    private static final String FOOTER = "FileCrawlerResultsSuffixTotalBytesFollows";
    private static final long serialVersionUID = 5365148610698773172L;
    protected static FileSearchControl searchControl;
    protected Serializer<FileSearchControl> searchControlSerializer;
    private FileDisplayTree resultTree = new FileDisplayTree(null);
    private HashMap<String, String> settings = new HashMap();
    private ExcludeList excludeList = new ExcludeList();
    private HashMap<String, Byte> flags = new HashMap();

    protected Results() {
    }

    @Override
    public void serialize(DataOutput output, Results instance) throws IOException {
        Results.INSTANCE.searchControlSerializer.serialize(output, searchControl);
        FileDisplayTree.INSTANCE.serialize(output, instance.resultTree);
        output.writeInt(instance.settings.size());
        Set<String> settingsKeySet = instance.settings.keySet();
        for (String setting : settingsKeySet) {
            output.writeUTF(setting);
            String value = instance.settings.get(setting);
            output.writeBoolean(value != null);
            if (value == null) continue;
            output.writeUTF(value);
        }
        Set<String> flagsKeySet = instance.flags.keySet();
        output.writeInt(flagsKeySet.size());
        for (String path : flagsKeySet) {
            output.writeUTF(path);
            output.writeByte(instance.flags.get(path).byteValue());
        }
        ExcludeList.INSTANCE.serialize(output, instance.excludeList);
        output.writeUTF(FOOTER);
        output.writeLong(output.bytesWritten());
    }

    @Override
    public Results deserialize(DataInput input) throws IOException {
        long expectedBytesRead;
        Results toReturn = new Results();
        searchControl = Results.INSTANCE.searchControlSerializer.deserialize(input);
        toReturn.resultTree = FileDisplayTree.INSTANCE.deserialize(input);
        int numSettings = input.readInt();
        int i = 0;
        while (i < numSettings) {
            String setting = input.readUTF();
            String value = null;
            if (input.readBoolean()) {
                value = input.readUTF();
            }
            toReturn.settings.put(setting, value);
            ++i;
        }
        int numFlags = input.readInt();
        int i2 = 0;
        while (i2 < numFlags) {
            String path = input.readUTF();
            byte flag = input.readByte();
            toReturn.flags.put(path, flag);
            ++i2;
        }
        toReturn.excludeList = ExcludeList.INSTANCE.deserialize(input);
        String footer = input.readUTF();
        if (!footer.equals(FOOTER)) {
            throw new IOException("expected file footer FileCrawlerResultsSuffixTotalBytesFollows, got " + footer);
        }
        long bytesRead = input.bytesRead();
        if (bytesRead != (expectedBytesRead = input.readLong())) {
            throw new IOException("expected " + expectedBytesRead + " bytes, read " + bytesRead);
        }
        return toReturn;
    }

    public FileDisplayTree resultTree() {
        return this.resultTree;
    }

    public FileSearchControl searchControl() {
        return searchControl;
    }

    public ExcludeList excludeList() {
        return this.excludeList;
    }

    public String readSetting(String setting) {
        return this.settings.get(setting);
    }

    public void writeSetting(String setting, String value) {
        this.settings.put(setting, value);
    }

    public Byte getFlag(String path) {
        return this.flags.get(path);
    }

    public void setFlag(String path, byte flag) {
        this.flags.put(path, flag);
    }

    public void removeFlag(String path) {
        this.flags.remove(path);
    }

    public void removeAllFlags() {
        this.flags.clear();
    }
}

