/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.database.DataInput;
import edu.uwyo.crawl.database.DataOutput;
import edu.uwyo.crawl.database.Serializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public interface FileSearchControl
extends Serializer<FileSearchControl> {
    public static final String HASH_DELIMITER = "__FileSearchControlQueryHash__";

    public boolean isSearchable(String var1, BasicFileAttributes var2);

    public Path root();

    public int numLevels();

    public void clear(File var1);

    public void update();

    public void loadSearchHash(String var1);

    public String getSearchHash();

    public FileSearchControl create();

    @Override
    default public void serialize(DataOutput output, FileSearchControl instance) throws IOException {
        output.writeUTF(instance.getSearchHash());
    }

    @Override
    default public FileSearchControl deserialize(DataInput input) throws IOException {
        FileSearchControl toReturn = this.create();
        toReturn.loadSearchHash(input.readUTF());
        return toReturn;
    }
}

