/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.database.DataInput;
import edu.uwyo.crawl.database.DataOutput;
import edu.uwyo.crawl.database.Serializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExcludeList
implements Serializable,
Serializer<ExcludeList> {
    public static final ExcludeList INSTANCE = new ExcludeList();
    private static final long serialVersionUID = -5626671390023171389L;
    private HashSet<String> files = new HashSet();
    private HashSet<String> extensions = new HashSet();
    private Pattern pattern;

    protected ExcludeList() {
    }

    @Override
    public void serialize(DataOutput output, ExcludeList instance) throws IOException {
        output.writeInt(instance.files.size());
        for (String file : instance.files) {
            output.writeUTF(file);
        }
        output.writeInt(instance.extensions.size());
        for (String extension : instance.extensions) {
            output.writeUTF(extension);
        }
        output.writeBoolean(instance.pattern != null);
        if (instance.pattern != null) {
            output.writeUTF(instance.pattern.toString());
        }
    }

    @Override
    public ExcludeList deserialize(DataInput input) throws IOException {
        ExcludeList toReturn = new ExcludeList();
        int numFiles = input.readInt();
        int i = 0;
        while (i < numFiles) {
            toReturn.files.add(input.readUTF());
            ++i;
        }
        int numExtensions = input.readInt();
        int i2 = 0;
        while (i2 < numExtensions) {
            toReturn.extensions.add(input.readUTF());
            ++i2;
        }
        if (input.readBoolean()) {
            toReturn.pattern = Pattern.compile(input.readUTF());
        }
        return toReturn;
    }

    public boolean isFileExcluded(String path, String ext) {
        Matcher m;
        if (ext != null && !ext.startsWith(".")) {
            ext = "." + ext;
        }
        if (ext != null && this.extensions.contains(ext.toLowerCase()) || path != null && this.files.contains(path)) {
            return true;
        }
        return path != null && this.pattern != null && (m = this.pattern.matcher(path)).find();
    }

    public boolean isDirExcluded(String path) {
        return this.files.contains(path);
    }

    public boolean isFileInExcludedDir(String filePath) {
        for (String path : this.files) {
            if (!filePath.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void addFile(String path) {
        if (path == null) {
            return;
        }
        this.files.add(path);
    }

    public void addExt(String ext) {
        if (ext == null) {
            return;
        }
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        this.extensions.add(ext);
    }

    public void removeFile(String path) {
        if (path == null) {
            return;
        }
        this.files.remove(path);
    }

    public void removeExt(String ext) {
        if (ext == null) {
            return;
        }
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        this.extensions.remove(ext);
    }

    public boolean matchesExt(String[] extensions) {
        if (extensions.length != this.extensions.size()) {
            return false;
        }
        int i = 0;
        while (i < extensions.length) {
            if (!this.extensions.contains(extensions[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean matchesFiles(String[] files) {
        if (files.length != this.files.size()) {
            return false;
        }
        int i = 0;
        while (i < files.length) {
            if (!this.files.contains(files[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String[] getExt() {
        if (this.extensions.size() == 0) {
            return null;
        }
        String[] toReturn = new String[this.extensions.size()];
        int curr = 0;
        Iterator<String> iterator = this.extensions.iterator();
        while (iterator.hasNext()) {
            String extension;
            toReturn[curr] = extension = iterator.next();
            ++curr;
        }
        return toReturn;
    }

    public String[] getFiles() {
        if (this.files.size() == 0) {
            return null;
        }
        String[] toReturn = new String[this.files.size()];
        int curr = 0;
        Iterator<String> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            String path;
            toReturn[curr] = path = iterator.next();
            ++curr;
        }
        return toReturn;
    }

    public String getPattern() {
        return this.pattern == null ? "" : this.pattern.toString();
    }

    public void setExt(String[] extensions) {
        this.extensions.clear();
        if (extensions != null) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                this.extensions.add(ext);
                ++n2;
            }
        }
    }

    public void setFiles(String[] files) {
        this.files.clear();
        if (files != null) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                this.files.add(path);
                ++n2;
            }
        }
    }
}

