/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.javamon.dev.ReaderTools;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.HTML;

public class DuplicateFinder {
    private static int headerSize = 1024;

    protected DuplicateFinder() {
    }

    public static void setHeaderSize(int headerSize) {
        DuplicateFinder.headerSize = headerSize;
    }

    protected void find(FileDisplayTree results, boolean names, boolean content, boolean exact) {
        HashSet<String> duplicates;
        Set<String> headerSet;
        HashSet<String> duplicates2;
        Scratch scratchName = new Scratch();
        Scratch scratchSize = new Scratch();
        Scratch scratchHeader = new Scratch();
        Scratch scratchExact = new Scratch();
        if (names) {
            this.putIntoScratch(results, scratchName, true, false);
        } else {
            this.putIntoScratch(results, scratchSize, false, true);
        }
        if (names && !content) {
            results.clear(Resources.__("mainDuplicateNameOnly", new Object[0]));
        } else if (!names && content && !exact) {
            results.clear(Resources.__("mainDuplicateContentOnly", new Object[0]));
        } else if (!names && content && exact) {
            results.clear(Resources.__("mainDuplicateContentOnlyExact", new Object[0]));
        } else if (names && content && !exact) {
            results.clear(Resources.__("mainDuplicateAll", new Object[0]));
        } else {
            results.clear(Resources.__("mainDuplicateAllExact", new Object[0]));
        }
        results.setFlatMode(true);
        if (names) {
            Set<String> nameSet = scratchName.keySet();
            for (String name : nameSet) {
                duplicates2 = scratchName.get(name);
                if (duplicates2.size() <= 1) continue;
                for (String path : duplicates2) {
                    if (!content) {
                        results.add(name, path, false, new File(path).length());
                        continue;
                    }
                    scratchSize.add(String.valueOf(new File(path).length()), path);
                }
            }
            if (!content) {
                return;
            }
        }
        Set<String> sizeSet = scratchSize.keySet();
        for (String size : sizeSet) {
            duplicates2 = scratchSize.get(size);
            if (duplicates2.size() <= 1) continue;
            for (String path : duplicates2) {
                String header = DuplicateFinder.getHeader(path);
                if (header == null) continue;
                scratchHeader.add(header, path);
            }
        }
        if (exact) {
            headerSet = scratchHeader.keySet();
            for (String header : headerSet) {
                duplicates = scratchHeader.get(header);
                if (duplicates.size() <= 1) continue;
                for (String path : duplicates) {
                    String contents = DuplicateFinder.getExact(path);
                    if (contents == null) continue;
                    scratchExact.add(contents, path);
                }
            }
            scratchHeader = scratchExact;
        }
        headerSet = scratchHeader.keySet();
        for (String header : headerSet) {
            duplicates = scratchHeader.get(header);
            String index = null;
            if (duplicates.size() <= 1) continue;
            for (String path : duplicates) {
                if (names) {
                    File file = new File(path);
                    results.add(file.getName(), path, false, file.length());
                    continue;
                }
                if (index == null) {
                    index = HTML.wrap(Resources.__("mainDuplicateFound", path));
                }
                results.add(index, path, false, new File(path).length());
            }
        }
    }

    private void putIntoScratch(FileDisplayTree curr, Scratch dest, boolean name, boolean size) {
        File file;
        if (curr.getFilePath() != null && !(file = new File(curr.getFilePath())).isDirectory()) {
            if (name) {
                dest.add(file.getName(), curr.getFilePath());
            } else if (size) {
                dest.add(String.valueOf(file.length()), curr.getFilePath());
            }
            return;
        }
        HashMap<String, FileDisplayTree> childrenMap = curr.getChildren();
        Set<String> children = childrenMap.keySet();
        for (String child : children) {
            this.putIntoScratch(childrenMap.get(child), dest, name, size);
        }
    }

    private static String getHeader(String path) {
        try {
            FileInputStream input = new FileInputStream(path);
            byte[] tempHeader = new byte[headerSize];
            input.read(tempHeader);
            input.close();
            return ReaderTools.toHex(tempHeader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getExact(String path) {
        try {
            byte[] contents = Files.readAllBytes(Paths.get(path, new String[0]));
            return ReaderTools.toHex(contents);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class Scratch {
        private HashMap<String, HashSet<String>> map = new HashMap();

        protected Scratch() {
        }

        protected Set<String> keySet() {
            return this.map.keySet();
        }

        protected HashSet<String> get(String key) {
            return this.map.get(key);
        }

        protected void add(String key, String value) {
            if (this.map.get(key) == null) {
                this.map.put(key, new HashSet());
            }
            this.map.get(key).add(value);
        }
    }
}

