/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.database.Crawler;
import edu.uwyo.crawl.database.DataInput;
import edu.uwyo.crawl.database.DataOutput;
import edu.uwyo.crawl.database.DuplicateFinder;
import edu.uwyo.crawl.database.FileSearchControl;
import edu.uwyo.crawl.database.Results;
import edu.uwyo.crawl.database.Serializer;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import net.javamon.dev.Console;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public class Database {
    private static int LARGE_NAME_SEARCH;
    private static int LARGE_CONTENT_SEARCH;
    private Results results;
    private boolean developerMode;
    private boolean commandLine;
    private final DataInput input = new DataInput();
    private final DataOutput output = new DataOutput();
    private final Crawler crawler = new Crawler(this);
    private final DuplicateFinder duplicateFinder = new DuplicateFinder();

    public Database(FileSearchControl searchControl, Serializer<FileSearchControl> searchControlSerializer) {
        Results.searchControl = searchControl;
        Results.INSTANCE.searchControlSerializer = searchControlSerializer;
        this.results = new Results();
    }

    public static void init() {
        try {
            LARGE_NAME_SEARCH = Integer.parseInt(Resources.readSetting("dbDuplicateWarningName"));
        }
        catch (Exception e) {
            LARGE_NAME_SEARCH = 50000;
        }
        try {
            LARGE_CONTENT_SEARCH = Integer.parseInt(Resources.readSetting("dbDuplicateWarningContent"));
        }
        catch (Exception e) {
            LARGE_CONTENT_SEARCH = 1000;
        }
    }

    public int numFiles() {
        return this.results.resultTree().size();
    }

    public void setDeveloperMode(boolean enable) {
        this.developerMode = enable;
    }

    public void setCommandLine(boolean verbose) {
        this.commandLine = true;
        this.crawler.setCommandLine(verbose);
    }

    public Results results() {
        return this.results;
    }

    public int numSearched() {
        return this.crawler.numSearched();
    }

    public boolean loadSearchResults(File snapshot) {
        try {
            this.input.setInput(new BufferedInputStream(new FileInputStream(snapshot), 8192));
            Results newResults = Results.INSTANCE.deserialize(this.input);
            this.input.close();
            this.results = newResults;
            return true;
        }
        catch (Exception e) {
            if (this.commandLine) {
                Console.logInfo(Resources.__("cmdErrorMsg", "loadSearchResults(File)", snapshot.getAbsolutePath(), Console.getStack(e, false)));
            } else {
                e.printStackTrace();
                if (this.developerMode) {
                    Prompt.errorScroll(Resources.__("mainDeveloperErrorH", new Object[0]), Resources.__("mainDeveloperErrorMsg", "loadSearchResults(File)", snapshot.getAbsolutePath(), Console.getStack(e, true)));
                }
            }
            return false;
        }
    }

    public boolean saveSearchResults(File destination) {
        try {
            this.output.setOutput(new BufferedOutputStream(new FileOutputStream(destination), 8192));
            Results.INSTANCE.serialize(this.output, this.results);
            this.output.close();
            return true;
        }
        catch (Exception e) {
            if (this.commandLine) {
                Console.logInfo(Resources.__("cmdErrorMsg", "saveSearchResults(File)", destination.getAbsolutePath(), Console.getStack(e, false)));
            } else {
                e.printStackTrace();
                if (this.developerMode) {
                    Prompt.errorScroll(Resources.__("mainDeveloperErrorH", new Object[0]), Resources.__("mainDeveloperErrorMsg", "saveSearchResults(File)", destination.getAbsolutePath(), Console.getStack(e, true)));
                }
            }
            return false;
        }
    }

    public FileDisplayTree search(boolean useCached, boolean searchCurrResults) {
        block5: {
            if (!useCached) {
                String[] toSearch = null;
                if (searchCurrResults) {
                    toSearch = this.results.resultTree().getPaths();
                }
                this.results.resultTree().clear(this.results.searchControl().root().toString());
                this.results.resultTree().setFlatMode(false);
                try {
                    this.crawler.run(this.results.searchControl(), this.results.excludeList(), this.developerMode && !this.commandLine, toSearch);
                }
                catch (Exception e) {
                    if (this.commandLine) {
                        Console.logInfo(Resources.__("cmdErrorMsg", "search(boolean)", "", Console.getStack(e, false)));
                    }
                    e.printStackTrace();
                    if (!this.developerMode) break block5;
                    Prompt.errorScroll(Resources.__("mainDeveloperErrorH", new Object[0]), Resources.__("mainDeveloperErrorMsg", "search(boolean)", "", Console.getStack(e, true)));
                }
            }
        }
        return this.results.resultTree();
    }

    public FileDisplayTree findDuplicates(boolean useCached, boolean names, boolean content, boolean exact, boolean searchCurrResults, String[] searchPaths, long[] searchSizes, String searchRoot) {
        if (!useCached) {
            long end;
            long start;
            int numFiles;
            block13: {
                int choice;
                if (!content && !names) {
                    names = true;
                }
                if (!searchCurrResults && searchPaths == null) {
                    this.search(false, false);
                }
                numFiles = this.numFiles();
                if (!this.commandLine && (content && numFiles >= LARGE_CONTENT_SEARCH || !content && numFiles >= LARGE_NAME_SEARCH) && (choice = Prompt.show(Resources.__("mainDuplicateSearchConfirmH", new Object[0]), Resources.__("mainDuplicateSearchConfirmMsg", numFiles))) != 0) {
                    return this.results.resultTree();
                }
                if (searchPaths != null) {
                    this.results.resultTree().clear(searchRoot);
                    int i = 0;
                    while (i < searchPaths.length) {
                        this.results.resultTree().add(null, searchPaths[i], false, searchSizes[i]);
                        ++i;
                    }
                }
                start = 0L;
                end = 0L;
                if (!this.commandLine) {
                    Console.windowLoad.suppressInvokable(true);
                }
                try {
                    start = System.nanoTime();
                    this.duplicateFinder.find(this.results.resultTree(), names, content, exact);
                    end = System.nanoTime();
                }
                catch (Exception e) {
                    if (this.commandLine) {
                        Console.logInfo(Resources.__("cmdErrorMsg", "findDuplicates(boolean, boolean, boolean, boolean)", String.valueOf(useCached) + ", " + names + ", " + content + ", " + exact, Console.getStack(e, false)));
                    }
                    e.printStackTrace();
                    if (!this.developerMode) break block13;
                    Prompt.errorScroll(Resources.__("mainDeveloperErrorH", new Object[0]), Resources.__("mainDeveloperErrorMsg", "findDuplicates(boolean, boolean, boolean, boolean)", String.valueOf(useCached) + ", " + names + ", " + content + ", " + exact, Console.getStack(e, true)));
                }
            }
            if ((this.developerMode || this.commandLine) && start != 0L && end != 0L) {
                float time = (float)(end - start) / 1.0E9f;
                float rate = (float)numFiles / time;
                if (this.commandLine) {
                    Console.logInfo(Resources.__("cmdDuplicateResultMsg", this.results.searchControl().root().toString(), numFiles, Float.valueOf(time), Float.valueOf(rate), String.valueOf(names), String.valueOf(content), String.valueOf(exact)));
                } else {
                    Prompt.messageScroll(Resources.__("mainCrawlDuplicateResultH", new Object[0]), Resources.__("mainCrawlDuplicateResultMsg", this.results.searchControl().root().toString(), numFiles, Float.valueOf(time), Float.valueOf(rate), String.valueOf(names), String.valueOf(content), String.valueOf(exact)));
                }
            }
        }
        return this.results.resultTree();
    }

    protected void addResult(File file) {
        this.results.resultTree().add(null, file.getAbsolutePath(), file.isDirectory(), file.length());
    }
}

