/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import java.io.IOException;
import java.io.OutputStream;

public class DataOutput {
    private OutputStream output;
    private long bytesWritten;

    public long bytesWritten() {
        return this.bytesWritten;
    }

    public void write(byte[] bytes) throws IOException {
        this.output.write(bytes);
        this.bytesWritten += (long)bytes.length;
    }

    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.output.write(bytes, offset, length);
        this.bytesWritten += (long)length;
    }

    public void writeByte(int value) throws IOException {
        this.output.write(value);
        ++this.bytesWritten;
    }

    public void writeBoolean(boolean value) throws IOException {
        this.writeByte(value ? 1 : 0);
    }

    public void writeShort(short value) throws IOException {
        this.writeByte(0xFF & value >> 8);
        this.writeByte(0xFF & value);
    }

    public void writeChar(char value) throws IOException {
        this.writeByte(value >>> 8);
        this.writeByte(value);
    }

    public void writeInt(int value) throws IOException {
        this.packInt(value);
    }

    public void writeLong(long value) throws IOException {
        this.packLong(value);
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeUTF(String value) throws IOException {
        int length = value.length();
        this.packInt(length);
        int i = 0;
        while (i < length) {
            this.packInt(value.charAt(i));
            ++i;
        }
    }

    protected void setOutput(OutputStream output) {
        this.output = output;
        this.bytesWritten = 0L;
    }

    protected void close() throws IOException {
        if (this.output != null) {
            this.output.close();
        }
    }

    private void packInt(int value) throws IOException {
        int shift = value & 0xFFFFFF80;
        if (shift != 0) {
            shift = 31 - Integer.numberOfLeadingZeros(value);
            shift -= shift % 7;
            while (shift != 0) {
                this.writeByte((byte)(value >>> shift & 0x7F));
                shift -= 7;
            }
        }
        this.writeByte((byte)(value & 0x7F | 0x80));
    }

    private void packLong(long value) throws IOException {
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.writeByte((byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        this.writeByte((byte)(value & 0x7FL | 0x80L));
    }
}

