/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import java.io.IOException;
import java.io.InputStream;

public class DataInput {
    private InputStream input;
    private long bytesRead;

    public long bytesRead() {
        return this.bytesRead;
    }

    public int read(byte[] buffer) throws IOException {
        int read = this.input.read(buffer);
        if (read == -1) {
            throw new IOException("end of input stream");
        }
        this.bytesRead += (long)read;
        return read;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        int read = this.input.read(buffer, offset, length);
        if (read == -1) {
            throw new IOException("end of input stream");
        }
        this.bytesRead += (long)read;
        return read;
    }

    public byte readByte() throws IOException {
        return (byte)this.readUnsignedByte();
    }

    public int readUnsignedByte() throws IOException {
        int readByte = this.input.read();
        if (readByte == -1) {
            throw new IOException("end of input stream");
        }
        int toReturn = (byte)readByte & 0xFF;
        ++this.bytesRead;
        return toReturn;
    }

    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.readUnsignedByte() * 256 + this.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return (char)(this.readUnsignedByte() << 8 | this.readUnsignedByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return this.unpackInt();
    }

    public long readLong() throws IOException {
        return this.unpackLong();
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readUTF() throws IOException {
        char[] characters = new char[this.unpackInt()];
        int i = 0;
        while (i < characters.length) {
            characters[i] = (char)this.unpackInt();
            ++i;
        }
        return new String(characters);
    }

    protected void setInput(InputStream input) {
        this.input = input;
        this.bytesRead = 0L;
    }

    protected void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }

    private int unpackInt() throws IOException {
        byte valueByte;
        int toReturn = 0;
        do {
            valueByte = this.readByte();
            toReturn = toReturn << 7 | valueByte & 0x7F;
        } while ((valueByte & 0x80) == 0);
        return toReturn;
    }

    private long unpackLong() throws IOException {
        byte valueByte;
        long toReturn = 0L;
        do {
            valueByte = this.readByte();
            toReturn = toReturn << 7 | (long)(valueByte & 0x7F);
        } while ((valueByte & 0x80) == 0);
        return toReturn;
    }
}

