/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.crawl.database.BasicFileVisitor;
import edu.uwyo.crawl.database.Database;
import edu.uwyo.crawl.database.ExcludeList;
import edu.uwyo.crawl.database.FileSearchControl;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import net.javamon.dev.Console;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public class Crawler {
    private FileSearchControl searchControl;
    private boolean commandLine;
    private boolean verbose;
    private final Database database;
    private final BasicFileVisitor visitor;
    private final Set<FileVisitOption> visitOptions;

    protected Crawler(Database database) {
        this.database = database;
        this.visitor = new BasicFileVisitor(this);
        this.visitOptions = EnumSet.noneOf(FileVisitOption.class);
    }

    protected int numSearched() {
        return this.visitor.numTotal();
    }

    protected void setCommandLine(boolean verbose) {
        this.commandLine = true;
        this.verbose = verbose;
    }

    protected boolean add(Path path, BasicFileAttributes attributes) {
        if (!this.searchControl.isSearchable(path.toString(), attributes)) {
            return false;
        }
        if (this.verbose) {
            Console.logInfo(path.toString());
        }
        this.database.addResult(path.toFile());
        return true;
    }

    protected void run(FileSearchControl searchControl, ExcludeList excludeList, boolean displayPrompt, String[] toSearch) throws IOException {
        this.searchControl = searchControl;
        this.visitor.reset(excludeList);
        long start = System.nanoTime();
        if (toSearch != null) {
            this.visitor.searchFiles(toSearch);
        } else {
            Files.walkFileTree(searchControl.root(), this.visitOptions, searchControl.numLevels(), this.visitor);
        }
        long end = System.nanoTime();
        float time = (float)(end - start) / 1.0E9f;
        float rate = (float)this.visitor.numTotal() / time;
        if (this.commandLine) {
            Console.logInfo(Resources.__("cmdCrawlResultMsg", searchControl.root().toString(), this.visitor.numTotal(), Float.valueOf(time), Float.valueOf(rate), this.visitor.numFound(), this.visitor.numSkipped()));
        } else if (displayPrompt) {
            Prompt.messageScroll(Resources.__("mainCrawlResultH", new Object[0]), Resources.__("mainCrawlResultMsg", searchControl.root().toString(), this.visitor.numTotal(), Float.valueOf(time), Float.valueOf(rate), this.visitor.numFound(), this.visitor.numSkipped()));
        }
    }
}

