/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.database;

import edu.uwyo.Main;
import edu.uwyo.crawl.database.Crawler;
import edu.uwyo.crawl.database.ExcludeList;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;

public class BasicFileVisitor
implements FileVisitor<Path> {
    private final Object LOCK = new Object();
    private int numFound;
    private int numSkipped;
    private ExcludeList excludeList;
    private final Crawler crawler;

    protected BasicFileVisitor(Crawler crawler) {
        this.crawler = crawler;
        this.reset(null);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.excludeList.isDirExcluded(dir.toString())) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!attrs.isDirectory() && this.crawler.add(file, attrs)) {
            Object object = this.LOCK;
            synchronized (object) {
                ++this.numFound;
            }
        }
        Object object = this.LOCK;
        synchronized (object) {
            ++this.numSkipped;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numTotal() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.numFound + this.numSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numFound() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.numFound;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int numSkipped() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.numSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset(ExcludeList excludeList) {
        Object object = this.LOCK;
        synchronized (object) {
            this.excludeList = excludeList;
            this.numFound = 0;
            this.numSkipped = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void searchFiles(String[] toSearch) throws IOException {
        int i = 0;
        while (i < toSearch.length) {
            block14: {
                if (toSearch[i] != null) {
                    Object object;
                    BasicFileAttributes attrs;
                    Path path = Paths.get(toSearch[i], new String[0]);
                    try {
                        attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                    }
                    catch (IOException e) {
                        Object object2 = this.LOCK;
                        synchronized (object2) {
                            ++this.numSkipped;
                            break block14;
                        }
                    }
                    if (!attrs.isDirectory() && !Main.excludeList().isFileInExcludedDir(toSearch[i]) && this.crawler.add(path, attrs)) {
                        object = this.LOCK;
                        synchronized (object) {
                            ++this.numFound;
                        }
                    }
                    object = this.LOCK;
                    synchronized (object) {
                        ++this.numSkipped;
                    }
                }
            }
            ++i;
        }
    }
}

