/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.contentMatcher;

import edu.uwyo.Main;
import edu.uwyo.crawl.contentMatcher.PatternParser;
import edu.uwyo.crawl.contentMatcher.TunableContentSearch;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import net.javamon.dev.Ext;
import net.javamon.dev.ZipUtils;

public class ZipMatcher
implements ZipUtils.ZipInvokable,
TunableContentSearch {
    private static final Pattern EXCLUDE_XML = Pattern.compile("<[^>]*>");
    private int maxChunkChars;
    private byte[] buffer;
    private final StringBuilder toParse;
    private final PatternParser parser;
    private final boolean stripXML;
    private final StringBuilder builder;
    private final String[] exclude;

    protected ZipMatcher(StringBuilder toParse, PatternParser parser, boolean stripXML, String ... exclude) {
        this.toParse = toParse;
        this.parser = parser;
        this.stripXML = stripXML;
        this.exclude = exclude;
        this.maxChunkChars = 256000000;
        this.buffer = new byte[8192];
        this.builder = new StringBuilder();
    }

    @Override
    public void start() {
        this.builder.setLength(0);
    }

    @Override
    public boolean invoke(ZipInputStream zipIn, String name) throws IOException {
        if (this.endsWith(name)) {
            return false;
        }
        this.clearBuffer();
        int count = zipIn.read(this.buffer);
        while (count != -1) {
            if (count > 0) {
                String chars = new String(this.buffer, 0, count, "UTF-8");
                int i = 0;
                while (i < chars.length()) {
                    if (chars.charAt(i) > '\u001f' && chars.charAt(i) != '\u007f' || chars.charAt(i) > '\b' && chars.charAt(i) < '\u000e') {
                        this.builder.append(chars.charAt(i));
                    }
                    ++i;
                }
                if (this.builder.length() >= this.maxChunkChars) {
                    this.append();
                    if (this.parser.find(this.toParse)) {
                        this.builder.setLength(0);
                        this.toParse.setLength(0);
                        return true;
                    }
                    this.builder.setLength(0);
                    this.toParse.setLength(0);
                }
            }
            count = zipIn.read(this.buffer);
        }
        this.append();
        this.builder.setLength(0);
        if (this.toParse.length() >= this.maxChunkChars) {
            if (this.parser.find(this.toParse)) {
                this.toParse.setLength(0);
                return true;
            }
            this.toParse.setLength(0);
        }
        return this.parser.find(this.toParse);
    }

    @Override
    public void tuneParameters(int bufferSize, int maxChunkBytes) {
        this.buffer = new byte[bufferSize];
        this.maxChunkChars = maxChunkBytes / 2;
    }

    private void clearBuffer() {
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i] = 0;
            ++i;
        }
    }

    private void append() {
        String toAppend = this.stripXML ? EXCLUDE_XML.matcher(this.builder).replaceAll("") : this.builder.toString();
        this.toParse.append(toAppend);
    }

    private boolean endsWith(String name) {
        if (this.exclude == null) {
            return false;
        }
        if (Main.excludeList().isFileExcluded(null, Ext.get(name))) {
            return true;
        }
        int i = 0;
        while (i < this.exclude.length) {
            if (name.endsWith(this.exclude[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

