/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.contentMatcher;

import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import edu.uwyo.crawl.contentMatcher.AbstractExpression;
import edu.uwyo.crawl.contentMatcher.BracketExpression;
import edu.uwyo.crawl.contentMatcher.CharExpression;
import edu.uwyo.crawl.contentMatcher.ConstantExpression;
import edu.uwyo.crawl.contentMatcher.EndExpression;
import edu.uwyo.crawl.contentMatcher.ExpressionTokenizer;
import edu.uwyo.crawl.contentMatcher.GroupExpression;
import edu.uwyo.crawl.contentMatcher.StartExpression;
import java.util.Stack;
import net.javamon.dev.Console;

public class PatternParser {
    private RunAutomaton toFind;
    private boolean atStart;
    private boolean atEnd;

    public boolean requireFull() {
        return this.atEnd;
    }

    public boolean find(CharSequence s) {
        return this.find(s, 0, s.length());
    }

    public boolean find(CharSequence s, int startOffset, int endOffset) {
        boolean found;
        if (this.toFind == null) {
            return false;
        }
        AutomatonMatcher matcher = this.toFind.newMatcher(s, startOffset, endOffset);
        while (found = matcher.find()) {
            if (this.atStart && matcher.start() != 0 || this.atEnd && matcher.end() != s.length()) continue;
            return true;
        }
        return false;
    }

    public void setPattern(String pattern) {
        ExpressionTokenizer tokenizer = this.parsePattern(pattern);
        String toFindPattern = tokenizer.toString();
        this.atStart = toFindPattern.startsWith("^");
        if (this.atStart) {
            toFindPattern = toFindPattern.substring(1);
        }
        boolean bl = this.atEnd = toFindPattern.endsWith("$") && !toFindPattern.endsWith("\\$");
        if (this.atEnd) {
            toFindPattern = toFindPattern.substring(0, toFindPattern.length() - 1);
        }
        Console.logInfo("expanded " + pattern + " to " + toFindPattern);
        this.toFind = new RunAutomaton(new RegExp(toFindPattern).toAutomaton());
    }

    private ExpressionTokenizer parsePattern(String pattern) {
        pattern = pattern.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\0", "\u0000").replace("\\f", "\f").replace("\\b", "\b");
        ExpressionTokenizer tokenizer = new ExpressionTokenizer();
        int i = 0;
        Stack<GroupExpression> groupExpressions = new Stack<GroupExpression>();
        while (i < pattern.length()) {
            ConstantExpression constantExpression;
            boolean forceContinue = false;
            if (!forceContinue && pattern.charAt(i) == '|') {
                if (groupExpressions.size() > 0) {
                    ((GroupExpression)groupExpressions.peek()).nextOrGroup();
                } else {
                    tokenizer.nextOrGroup();
                }
                forceContinue = true;
            }
            if (!forceContinue && pattern.charAt(i) == '\\') {
                constantExpression = new ConstantExpression();
                int jump = this.parseMetaCharacter(i + 1, pattern, constantExpression);
                if (jump == 0) {
                    constantExpression.add(new CharExpression(String.valueOf(pattern.charAt(i)) + pattern.charAt(i + 1)), 1);
                    jump = 1;
                }
                if ((i += jump) + 1 < pattern.length() && pattern.charAt(i + 1) == '{') {
                    i += this.parseRepeat(i + 1, pattern, constantExpression);
                }
                if (i + 1 < pattern.length()) {
                    if (pattern.charAt(i + 1) == '*') {
                        ++i;
                        constantExpression.zeroOrMore();
                    } else if (pattern.charAt(i + 1) == '+') {
                        ++i;
                        constantExpression.oneOrMore();
                    }
                }
                if (groupExpressions.size() == 0) {
                    tokenizer.add(constantExpression, constantExpression.length());
                } else {
                    ((GroupExpression)groupExpressions.peek()).add(constantExpression, constantExpression.length());
                }
                forceContinue = true;
            }
            if (!forceContinue && pattern.charAt(i) == '[') {
                BracketExpression bracketExpression = new BracketExpression();
                ++i;
                while (i < pattern.length()) {
                    if (pattern.charAt(i) == '\\') {
                        if (pattern.charAt(i + 1) == 'x') {
                            i += this.parseHex(i + 2, pattern, bracketExpression);
                        } else {
                            bracketExpression.add(new CharExpression(String.valueOf(pattern.charAt(i)) + pattern.charAt(i + 1)), 1);
                            ++i;
                        }
                    } else {
                        if (pattern.charAt(i) == ']') {
                            if (i + 1 < pattern.length()) {
                                if (pattern.charAt(i + 1) == '*') {
                                    ++i;
                                    bracketExpression.zeroOrMore();
                                } else if (pattern.charAt(i + 1) == '+') {
                                    ++i;
                                    bracketExpression.oneOrMore();
                                }
                            }
                            if (groupExpressions.size() == 0) {
                                tokenizer.add(bracketExpression, bracketExpression.length());
                            } else {
                                ((GroupExpression)groupExpressions.peek()).add(bracketExpression, bracketExpression.length());
                            }
                            forceContinue = true;
                            break;
                        }
                        bracketExpression.add(new CharExpression(pattern.charAt(i)), 1);
                    }
                    ++i;
                }
            }
            if (!forceContinue && pattern.charAt(i) == '(') {
                groupExpressions.push(new GroupExpression());
                forceContinue = true;
            }
            if (!forceContinue && groupExpressions.size() > 0 && pattern.charAt(i) == ')') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '{') {
                    i += this.parseRepeat(i + 1, pattern, (AbstractExpression)groupExpressions.peek());
                }
                if (i + 1 < pattern.length()) {
                    if (pattern.charAt(i + 1) == '*') {
                        ++i;
                        ((GroupExpression)groupExpressions.peek()).zeroOrMore();
                    } else if (pattern.charAt(i + 1) == '+') {
                        ++i;
                        ((GroupExpression)groupExpressions.peek()).oneOrMore();
                    }
                }
                tokenizer.add((AbstractExpression)groupExpressions.peek(), ((GroupExpression)groupExpressions.peek()).length());
                groupExpressions.pop();
                forceContinue = true;
            }
            if (!forceContinue && pattern.charAt(i) == '^') {
                StartExpression startExpression = new StartExpression();
                if (groupExpressions.size() == 0) {
                    tokenizer.add(startExpression, startExpression.length());
                } else {
                    ((GroupExpression)groupExpressions.peek()).add(startExpression, startExpression.length());
                }
                forceContinue = true;
            }
            if (!forceContinue && pattern.charAt(i) == '$') {
                EndExpression endExpression = new EndExpression();
                if (groupExpressions.size() == 0) {
                    tokenizer.add(endExpression, endExpression.length());
                } else {
                    ((GroupExpression)groupExpressions.peek()).add(endExpression, endExpression.length());
                }
                forceContinue = true;
            }
            if (!forceContinue) {
                constantExpression = new ConstantExpression();
                constantExpression.add(new CharExpression(pattern.charAt(i)), 1);
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '{') {
                    i += this.parseRepeat(i + 1, pattern, constantExpression);
                }
                if (i + 1 < pattern.length()) {
                    if (pattern.charAt(i + 1) == '*') {
                        ++i;
                        constantExpression.zeroOrMore();
                    } else if (pattern.charAt(i + 1) == '+') {
                        ++i;
                        constantExpression.oneOrMore();
                    }
                }
                if (groupExpressions.size() == 0) {
                    tokenizer.add(constantExpression, constantExpression.length());
                } else {
                    ((GroupExpression)groupExpressions.peek()).add(constantExpression, constantExpression.length());
                }
                forceContinue = true;
            }
            ++i;
        }
        return tokenizer;
    }

    private int parseMetaCharacter(int i, String pattern, AbstractExpression expression) {
        BracketExpression bracketExpression = new BracketExpression();
        switch (pattern.charAt(i)) {
            case 's': {
                bracketExpression.add(new CharExpression(" \\t\\n\\r"), 1);
                break;
            }
            case 'S': {
                bracketExpression.add(new CharExpression("^ \\t\\n\\r"), 1);
                break;
            }
            case 'd': {
                bracketExpression.add(new CharExpression("0-9"), 1);
                break;
            }
            case 'D': {
                bracketExpression.add(new CharExpression("^0-9"), 1);
                break;
            }
            case 'w': {
                bracketExpression.add(new CharExpression("a-zA-Z0-9_"), 1);
                break;
            }
            case 'W': {
                bracketExpression.add(new CharExpression("^a-zA-Z0-9_"), 1);
                break;
            }
            case 'x': {
                return this.parseHex(i, pattern, expression);
            }
            case 'h': {
                bracketExpression.add(new CharExpression(" \\t"), 1);
                break;
            }
            case 'H': {
                bracketExpression.add(new CharExpression("^ \\t"), 1);
                break;
            }
            case 'v': {
                bracketExpression.add(new CharExpression("\\n\\r"), 1);
                break;
            }
            case 'V': {
                bracketExpression.add(new CharExpression("^\\n\\r"), 1);
                break;
            }
            default: {
                return 0;
            }
        }
        expression.add(bracketExpression, 1);
        return 1;
    }

    private int parseHex(int i, String pattern, AbstractExpression expression) {
        if (pattern.charAt(i) != 'x') {
            return 0;
        }
        String hexCode = null;
        int jump = 0;
        if (pattern.charAt(i + 1) == '{' && i + 6 < pattern.length() && pattern.charAt(i + 6) == '}') {
            hexCode = pattern.substring(i + 2, i + 6);
            jump = 7;
        } else if (i + 2 < pattern.length()) {
            hexCode = "00" + pattern.substring(i + 1, i + 3);
            jump = 3;
        }
        if (hexCode != null) {
            try {
                char unicode = (char)Integer.parseInt(hexCode, 16);
                expression.add(new CharExpression(unicode), 1);
            }
            catch (NumberFormatException e) {
                jump = 0;
            }
        }
        return jump;
    }

    private int parseRepeat(int i, String pattern, AbstractExpression expression) {
        int start = i + 1;
        int end = i + 1;
        int seek = i;
        while (seek < pattern.length()) {
            if (pattern.charAt(seek) == '}') {
                end = seek;
                break;
            }
            ++seek;
        }
        String[] startEnd = pattern.substring(start, end).split(",");
        if (startEnd.length > 0 && startEnd.length <= 2) {
            try {
                int startVal = Integer.parseInt(startEnd[0]);
                int endVal = -1;
                if (startEnd.length == 2) {
                    endVal = Integer.parseInt(startEnd[1]);
                }
                expression.repeat(startVal, endVal);
                return pattern.substring(start, end).length() + 2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }
}

