/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.contentMatcher;

import edu.uwyo.crawl.contentMatcher.PatternParser;
import edu.uwyo.crawl.contentMatcher.TunableContentSearch;
import edu.uwyo.crawl.contentMatcher.ZipMatcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import net.javamon.dev.Console;
import net.javamon.dev.ZipUtils;

public class ContentMatcher
implements TunableContentSearch {
    private boolean enabled;
    private int maxChunkChars = 256000000;
    private char[] buffer;
    private final PatternParser parser = new PatternParser();
    private final StringBuilder fileChars = new StringBuilder();
    private final ZipMatcher zipMatcher = new ZipMatcher(this.fileChars, this.parser, false, ".bin");
    private final ZipMatcher noXMLMatcher = new ZipMatcher(this.fileChars, this.parser, true, ".bin", "docProps/core.xml", "docProps/app.xml");

    public ContentMatcher() {
        this.buffer = new char[8192];
    }

    @Override
    public void tuneParameters(int bufferSize, int maxChunkBytes) {
        if (bufferSize / 2 != this.buffer.length) {
            Console.logInfo("buffer size set to " + bufferSize);
            this.buffer = new char[bufferSize / 2];
            this.zipMatcher.tuneParameters(bufferSize, maxChunkBytes);
            this.noXMLMatcher.tuneParameters(bufferSize, maxChunkBytes);
        }
        this.maxChunkChars = maxChunkBytes / 2;
    }

    public void setPattern(Pattern pattern) {
        boolean bl = this.enabled = pattern != null;
        if (pattern != null) {
            this.parser.setPattern(pattern.toString());
        }
    }

    public boolean find(String path) throws Exception {
        if (!this.enabled) {
            return false;
        }
        this.fileChars.setLength(0);
        String lower = path.toLowerCase();
        if (lower.endsWith(".xlsx") || lower.endsWith(".docx") || lower.endsWith(".pptx")) {
            return ZipUtils.invoke(new File(path), this.noXMLMatcher);
        }
        if (lower.endsWith(".zip")) {
            return ZipUtils.invoke(new File(path), this.zipMatcher);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"), this.buffer.length);
        int charsRead = 0;
        while (charsRead != -1) {
            charsRead = reader.read(this.buffer);
            if (charsRead == -1) continue;
            int i = 0;
            while (i < charsRead) {
                if (this.buffer[i] > '\u001f' && this.buffer[i] != '\u007f' || this.buffer[i] > '\b' && this.buffer[i] < '\u000e') {
                    this.fileChars.append(this.buffer[i]);
                }
                ++i;
            }
            if (this.fileChars.length() < this.maxChunkChars) continue;
            if (this.parser.find(this.fileChars)) {
                reader.close();
                return true;
            }
            this.fileChars.setLength(0);
        }
        reader.close();
        return this.parser.find(this.fileChars);
    }
}

