/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl.contentMatcher;

import java.util.ArrayList;

public abstract class AbstractExpression {
    protected static final int EXACT = 0;
    protected static final int ZERO_OR_MORE = 1;
    protected static final int ONE_OR_MORE = 2;
    protected int currOrGroup;
    protected ArrayList<Integer> length;
    protected ArrayList<ArrayList<AbstractExpression>> expressions = new ArrayList();
    private int mode;
    private int repeatMin;
    private int repeatMax;

    protected AbstractExpression() {
        this.length = new ArrayList();
        this.expressions.add(new ArrayList());
        this.length.add(0);
        this.currOrGroup = this.expressions.size() - 1;
        this.mode = 0;
        this.repeatMin = -1;
        this.repeatMax = -1;
    }

    public abstract void toString(StringBuilder var1);

    protected abstract void add(AbstractExpression var1, int var2);

    public int length() {
        int minLength = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.length.size()) {
            if (this.repeatMin >= 0) {
                minLength = Math.min(minLength, this.length.get(i) * this.repeatMin);
            } else {
                switch (this.mode) {
                    case 2: {
                        minLength = Math.min(minLength, 1);
                        break;
                    }
                    case 1: {
                        minLength = Math.min(minLength, 0);
                        break;
                    }
                    default: {
                        minLength = Math.min(minLength, this.length.get(i));
                    }
                }
            }
            ++i;
        }
        return minLength;
    }

    protected void zeroOrMore() {
        this.mode = 1;
    }

    protected void oneOrMore() {
        this.mode = 2;
    }

    protected void repeat(int min, int max) {
        this.repeatMin = min;
        this.repeatMax = max;
    }

    protected void nextOrGroup() {
        this.expressions.add(new ArrayList());
        this.length.add(0);
        this.currOrGroup = this.expressions.size() - 1;
    }

    protected void appendNumMatches(StringBuilder builder) {
        if (this.repeatMin >= 0) {
            builder.append("{");
            builder.append(this.repeatMin);
            if (this.repeatMax == this.repeatMin) {
                builder.append(",");
            } else if (this.repeatMax > this.repeatMin) {
                builder.append("," + this.repeatMax);
            }
            builder.append("}");
        }
        if (this.isZeroOrMore()) {
            builder.append("*");
        } else if (this.isOneOrMore()) {
            builder.append("+");
        }
    }

    private boolean isZeroOrMore() {
        return this.mode == 1;
    }

    private boolean isOneOrMore() {
        return this.mode == 2;
    }
}

