/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl;

import edu.uwyo.Main;
import edu.uwyo.crawl.Query;
import edu.uwyo.crawl.database.Database;
import edu.uwyo.crawl.ui.panels.PanelFiles;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.javamon.dev.Console;
import net.javamon.dev.Resources;
import net.javamon.dev.utils.commandParser.CommandLineParser;
import net.javamon.dev.utils.commandParser.OptionMap;
import net.javamon.dev.utils.commandParser.option.BooleanOptionBuilder;
import net.javamon.dev.utils.commandParser.option.IntegerOptionBuilder;
import net.javamon.dev.utils.commandParser.option.Option;
import net.javamon.dev.utils.commandParser.option.OptionType;
import net.javamon.dev.utils.commandParser.option.StringOptionBuilder;

public class QueryParams {
    private static final Pattern VALID_EXTENSION = Pattern.compile("\\.?[a-zA-Z0-9_]+");
    private File input;
    private File output;
    private int sizeMode;
    private Query query;
    private final Database database;
    private final OptionMap options;

    public QueryParams(Database database) {
        this.database = database;
        Option help = new BooleanOptionBuilder(false, false, "h", "help").description(Resources.__("cmdHelp", new Object[0])).build();
        this.options = new OptionMap(help);
        this.options.put(new StringOptionBuilder(true, true, "f", "file").description(Resources.__("cmdSearch", new Object[0])));
        this.options.put(new StringOptionBuilder(true, true, "o", "output").description(Resources.__("cmdOutput", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "i", "input").description(Resources.__("cmdInput", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "r", "recurse").defaultArgument(0).description(Resources.__("cmdRecurse", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "d", "duplicateMode").defaultArgument(0).description(Resources.__("cmdDuplicate", new Object[0])));
        this.options.put(new BooleanOptionBuilder(false, false, "D", "duplicateExact").description(Resources.__("cmdDuplicateExact", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "p", "patternName").description(Resources.__("cmdPatternName", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "P", "patternContent").description(Resources.__("cmdPatternContent", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "c", "created").defaultArgument("-1:-1").description(Resources.__("cmdCreated", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "m", "modified").defaultArgument("-1:-1").description(Resources.__("cmdModified", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "a", "accessed").defaultArgument("-1:-1").description(Resources.__("cmdAccessed", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "s", "size").defaultArgument("0,-1:-1").description(Resources.__("cmdSize", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "x", "extInclude").description(Resources.__("cmdExt", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "X", "extExclude").description(Resources.__("cmdExtExclude", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "F", "fileExclude").description(Resources.__("cmdFileExclude", new Object[0])));
        this.options.put(new StringOptionBuilder(false, true, "N", "filePatternExclude").description(Resources.__("cmdFilePatternExclude", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "H", "headerSize").defaultArgument(1024).description(Resources.__("cmdHeaderSize", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "b", "bufferLocal").defaultArgument(16384).description(Resources.__("cmdBufferLocal", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "B", "bufferNet").defaultArgument(0x1000000).description(Resources.__("cmdBufferNet", new Object[0])));
        this.options.put(new IntegerOptionBuilder(false, true, "C", "chunkSize").defaultArgument(512).description(Resources.__("cmdChunkSize", new Object[0])));
        this.options.put(new BooleanOptionBuilder(false, false, "v", "verbose").description(Resources.__("cmdVerbose", new Object[0])));
    }

    public boolean parse(String[] args) {
        try {
            if (CommandLineParser.parse(args, 0, this.options)) {
                this.showHelp();
                return false;
            }
        }
        catch (CommandLineParser.UnknownOptionException e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorUnknownOption", e.token));
            this.showHelp();
            return false;
        }
        catch (CommandLineParser.MissingArgumentException e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorMissingArgument", e.token));
            this.showHelp();
            return false;
        }
        catch (CommandLineParser.MissingOptionException e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorMissingOption", e.option.getTokens()));
            this.showHelp();
            return false;
        }
        catch (OptionType.BadTypeException e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorUnknownOption", e.value, e.typeConverter.getDisplayType()));
            this.showHelp();
            return false;
        }
        catch (CommandLineParser.MultipleDefinitionException e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorMultiple", e.token));
            this.showHelp();
            return false;
        }
        this.database.setCommandLine(this.options.getBoolean("verbose") != null);
        try {
            this.setInput();
            this.setFiles();
            this.setNesting();
            this.setDuplicates();
            this.setPatternName();
            this.setPatternContent();
            this.setCreated();
            this.setModified();
            this.setAccessed();
            this.setSize();
            this.setExt();
            this.setExcludeExt();
            this.setExcludeFiles();
            this.setExcludePattern();
            this.setHeaderSize();
            this.setBufferLocal();
            this.setBufferNet();
            this.setChunkSize();
        }
        catch (RuntimeException e) {
            this.query = null;
            return false;
        }
        return true;
    }

    public void run() {
        if (this.query != null) {
            FileDisplayTree results = this.query.run(this.database, true);
            this.writeSettings();
            if (this.database.saveSearchResults(this.output)) {
                Console.logInfo(String.valueOf(Resources.__("cmdSave", this.output.getAbsolutePath())) + "\n");
            } else {
                Console.logInfo(String.valueOf(Resources.__("cmdErrorSave", this.output.getAbsolutePath())) + "\n");
                String[] paths = results.getPaths();
                int i = 0;
                while (i < paths.length) {
                    Console.logInfo("\n" + paths[i]);
                    ++i;
                }
            }
        }
    }

    private void showHelp() {
        Console.logInfo("\n" + Resources.__("cmdUsage", new Object[0]));
        Console.logInfo(this.options.getHelp());
    }

    private void setInput() {
        this.input = null;
        String i = this.options.getString("input");
        if (i != null) {
            this.input = new File(i);
            if (!this.input.isFile()) {
                Console.logInfo("\n\n" + Resources.__("cmdErrorInput", i));
                throw new RuntimeException();
            }
        }
        if (this.input != null && !this.database.loadSearchResults(this.input)) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorInputRead", this.input.getAbsolutePath()));
            throw new RuntimeException();
        }
        this.query = Main.query();
    }

    private void setFiles() {
        this.query.toSearch = new File(this.options.getString("file"));
        this.output = new File(this.options.getString("output"));
    }

    private void setNesting() {
        this.query.nesting = Math.min(7, Math.max(0, this.options.getInt("recurse")));
        if (this.input != null && this.input.isFile()) {
            this.query.nesting = 8;
        }
        if (this.query.nesting == 0 && !this.query.toSearch.isFile()) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorSearchFile", this.query.toSearch.getAbsolutePath()));
            throw new RuntimeException();
        }
        if (this.query.nesting != 0 && !this.query.toSearch.isDirectory()) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorSearchDir", this.query.toSearch.getAbsolutePath()));
            throw new RuntimeException();
        }
        if (this.query.nesting == 7) {
            this.query.nesting = Integer.MAX_VALUE;
        } else if (this.query.nesting == 0) {
            this.query.fileMode = this.query.toSearch.getAbsolutePath();
            this.query.toSearch = this.query.toSearch.getParentFile();
            this.query.nesting = 1;
        }
    }

    private void setDuplicates() {
        this.query.duplicateMode = this.options.getInt("duplicateMode");
        if (this.query.duplicateMode < 0 || this.query.duplicateMode > 3) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorDuplicate", this.query.duplicateMode));
            throw new RuntimeException();
        }
        this.query.duplicateExact = this.options.getBoolean("duplicateExact") != null && this.query.duplicateMode > 0;
    }

    private void setPatternName() {
        this.query.patternName = null;
        String p = this.options.getString("patternName");
        if (p != null) {
            try {
                this.query.patternName = Pattern.compile(p);
            }
            catch (PatternSyntaxException e) {
                Console.logInfo("\n\n" + Resources.__("cmdErrorPatternName", p));
                throw new RuntimeException();
            }
        }
    }

    private void setPatternContent() {
        this.query.patternContent = null;
        String P = this.options.getString("patternName");
        if (P != null) {
            try {
                this.query.patternName = Pattern.compile(P);
            }
            catch (PatternSyntaxException e) {
                Console.logInfo("\n\n" + Resources.__("cmdErrorPatternContent", P));
                throw new RuntimeException();
            }
        }
    }

    private void setCreated() {
        String c = this.options.getString("created");
        try {
            String[] cTokens = c.split(":");
            this.query.createdStart = Long.parseLong(cTokens[0]);
            this.query.createdEnd = Long.parseLong(cTokens[1]);
            if (this.query.createdStart >= this.query.createdEnd && this.query.createdStart != -1L || this.query.createdStart < -1L || this.query.createdEnd < -1L) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorCreateFormat", c));
            throw new RuntimeException();
        }
    }

    private void setModified() {
        String m = this.options.getString("modified");
        try {
            String[] mTokens = m.split(":");
            this.query.modifiedStart = Long.parseLong(mTokens[0]);
            this.query.modifiedEnd = Long.parseLong(mTokens[1]);
            if (this.query.modifiedStart >= this.query.modifiedEnd && this.query.modifiedStart != -1L || this.query.modifiedStart < -1L || this.query.modifiedEnd < -1L) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorModifyFormat", m));
            throw new RuntimeException();
        }
    }

    private void setAccessed() {
        String a = this.options.getString("accessed");
        try {
            String[] aTokens = a.split(":");
            this.query.accessedStart = Long.parseLong(aTokens[0]);
            this.query.accessedEnd = Long.parseLong(aTokens[1]);
            if (this.query.accessedStart >= this.query.accessedEnd && this.query.accessedStart != -1L || this.query.accessedStart < -1L || this.query.accessedEnd < -1L) {
                throw new RuntimeException();
            }
        }
        catch (Exception e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorAccessFormat", a));
            throw new RuntimeException();
        }
    }

    private void setSize() {
        this.query.sizeSmallerWarning = -1L;
        this.query.sizeSmallerError = -1L;
        this.query.sizeLargerWarning = -1L;
        this.query.sizeLargerError = -1L;
        this.query.sizeSmaller = -1L;
        this.query.sizeLarger = -1L;
        String s = this.options.getString("size");
        try {
            String sSub = s.substring(0, s.indexOf(44));
            this.sizeMode = Integer.parseInt(sSub);
            String[] sTokens = s.substring(s.indexOf(44) + 1).split(":");
            switch (this.sizeMode) {
                case 1: {
                    this.query.sizeSmallerWarning = Long.parseLong(sTokens[0]);
                    this.query.sizeSmallerError = Long.parseLong(sTokens[1]);
                    if (this.query.sizeSmallerWarning < this.query.sizeSmallerError || this.query.sizeSmallerWarning <= 0L || this.query.sizeSmallerError <= 0L) {
                        throw new RuntimeException();
                    }
                    break;
                }
                case 2: {
                    this.query.sizeLargerWarning = Long.parseLong(sTokens[0]);
                    this.query.sizeLargerError = Long.parseLong(sTokens[1]);
                    if (this.query.sizeLargerWarning > this.query.sizeLargerError || this.query.sizeLargerWarning <= 0L || this.query.sizeLargerError <= 0L) {
                        throw new RuntimeException();
                    }
                    break;
                }
                case 3: {
                    this.query.sizeSmaller = Long.parseLong(sTokens[0]);
                    this.query.sizeLarger = Long.parseLong(sTokens[1]);
                    if (this.query.sizeSmaller > this.query.sizeLarger || this.query.sizeSmaller <= 0L || this.query.sizeLarger <= 0L) {
                        throw new RuntimeException();
                    }
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        catch (Exception e) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorSizeFormat", s));
            throw new RuntimeException();
        }
    }

    private void setExt() {
        this.query.extensions = null;
        String x = this.options.getString("extInclude");
        if (x != null) {
            String[] stringArray = this.query.extensions = x.split(",");
            int n = this.query.extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (!VALID_EXTENSION.matcher(extension).matches()) {
                    Console.logInfo("\n\n" + Resources.__("cmdErrorExt", extension));
                    throw new RuntimeException();
                }
                ++n2;
            }
        }
    }

    private void setExcludeExt() {
        this.query.excludedExtensions = null;
        String X = this.options.getString("extExclude");
        if (X != null) {
            String[] stringArray = this.query.excludedExtensions = X.split(",");
            int n = this.query.excludedExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (!VALID_EXTENSION.matcher(extension).matches()) {
                    Console.logInfo("\n\n" + Resources.__("cmdErrorExcludeExt", extension));
                    throw new RuntimeException();
                }
                ++n2;
            }
        }
    }

    private void setExcludeFiles() {
        this.query.excludedFiles = null;
        String F = this.options.getString("fileExclude");
        if (F != null) {
            this.query.excludedFiles = F.split(",");
        }
    }

    private void setExcludePattern() {
        this.query.excludedPattern = null;
        String N = this.options.getString("filePatternExclude");
        if (N != null) {
            try {
                this.query.excludedPattern = Pattern.compile(N);
            }
            catch (PatternSyntaxException e) {
                Console.logInfo("\n\n" + Resources.__("cmdErrorPatternExclude", N));
                throw new RuntimeException();
            }
        }
    }

    private void setHeaderSize() {
        this.query.headerSize = this.options.getInt("headerSize");
        if (this.query.headerSize < 1) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorHeaderSize", this.query.headerSize));
            throw new RuntimeException();
        }
    }

    private void setBufferLocal() {
        this.query.bufferLocal = this.options.getInt("bufferLocal");
        if (this.query.bufferLocal < 1) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorBufferLocal", this.query.bufferLocal));
            throw new RuntimeException();
        }
    }

    private void setBufferNet() {
        this.query.bufferNet = this.options.getInt("bufferNet");
        if (this.query.bufferNet < 1) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorBufferNet", this.query.bufferNet));
            throw new RuntimeException();
        }
    }

    private void setChunkSize() {
        this.query.chunkSize = this.options.getInt("chunkSize");
        if (this.query.chunkSize < 1) {
            Console.logInfo("\n\n" + Resources.__("cmdErrorChunkSize", this.query.chunkSize));
            throw new RuntimeException();
        }
    }

    private void writeSettings() {
        Main.writeSetting("lastFolder", this.query.toSearch.getAbsolutePath());
        this.writePatternSetting("Name", this.query.patternName);
        this.writePatternSetting("Content", this.query.patternContent);
        this.writeNestingSetting();
        Main.writeSetting("lastDuplicate", String.valueOf(this.query.duplicateMode));
        Main.writeSetting("lastDuplicateExact", this.query.duplicateExact ? "True" : "False");
        this.writeExtensionSettings();
        this.writeSizeSettings();
        this.writeDateSetting("Created", this.query.createdStart, this.query.createdEnd);
        this.writeDateSetting("Modified", this.query.modifiedStart, this.query.modifiedEnd);
        this.writeDateSetting("Accessed", this.query.accessedStart, this.query.accessedEnd);
        int i = 0;
        while (i < PanelFiles.getNumFlags()) {
            Main.writeSetting("lastFlagFilter" + i, "True");
            ++i;
        }
    }

    private void writePatternSetting(String patternName, Pattern pattern) {
        if (pattern == null) {
            Main.writeSetting("lastPattern" + patternName, "");
        } else {
            Main.writeSetting("lastPattern" + patternName, pattern.toString());
        }
    }

    private void writeNestingSetting() {
        if (this.query.nesting == 1 && this.query.fileMode != null) {
            Main.writeSetting("lastRecurse", "0");
        } else if (this.query.nesting == Integer.MAX_VALUE) {
            Main.writeSetting("lastRecurse", "7");
        } else {
            Main.writeSetting("lastRecurse", String.valueOf(this.query.nesting));
        }
    }

    private void writeExtensionSettings() {
        if (this.query.extensions == null) {
            Main.writeSetting("lastFileTypes", "");
            return;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.query.extensions.length) {
            if (this.query.extensions[i].startsWith(".")) {
                builder.append(this.query.extensions[i]);
            } else {
                builder.append("." + this.query.extensions[i]);
            }
            if (i < this.query.extensions.length - 1) {
                builder.append(" ");
            }
            ++i;
        }
        Main.writeSetting("lastFileTypes", builder.toString());
    }

    private void writeSizeSettings() {
        Main.writeSetting("lastSizeMode", String.valueOf(this.sizeMode));
        switch (this.sizeMode) {
            case 1: {
                this.writeSize(this.query.sizeSmallerWarning, this.query.sizeSmallerError);
                break;
            }
            case 2: {
                this.writeSize(this.query.sizeLargerWarning, this.query.sizeLargerError);
                break;
            }
            case 3: {
                this.writeSize(this.query.sizeSmaller, this.query.sizeLarger);
                break;
            }
            default: {
                this.writeSize(0L, 0L);
            }
        }
        Main.writeSetting("lastSizeWarningUnits", "0");
        Main.writeSetting("lastSizeErrorUnits", "0");
    }

    private void writeSize(long lower, long upper) {
        Main.writeSetting("lastSizeWarning", String.valueOf(lower / 1024L));
        Main.writeSetting("lastSizeError", String.valueOf(upper / 1024L));
    }

    private void writeDateSetting(String dateLabel, long start, long end) {
        Main.writeSetting("lastTime" + dateLabel + "Enabled", start > -1L || end > -1L ? "True" : "False");
        Main.writeSetting("lastTime" + dateLabel + "Comparison", String.valueOf(this.getDateMode(start, end)));
        Main.writeSetting("lastTime" + dateLabel + "DateMin", String.valueOf(start));
        Main.writeSetting("lastTime" + dateLabel + "DateMax", String.valueOf(end));
    }

    private int getDateMode(long start, long end) {
        if (start == -1L && end == -1L) {
            return 0;
        }
        if (start == -1L) {
            return 0;
        }
        if (end == -1L) {
            return 1;
        }
        return 2;
    }
}

