/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo.crawl;

import edu.uwyo.Main;
import edu.uwyo.crawl.contentMatcher.ContentMatcher;
import edu.uwyo.crawl.database.Database;
import edu.uwyo.crawl.database.DuplicateFinder;
import edu.uwyo.crawl.database.FileSearchControl;
import edu.uwyo.crawl.ui.panels.PanelOptionsSize;
import edu.uwyo.crawl.ui.panels.PanelTime;
import edu.uwyo.crawl.ui.tree.FileDisplayTree;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.javamon.dev.Ext;
import net.javamon.dev.FileUtils;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public class Query
implements FileSearchControl {
    public static final Query INSTANCE = new Query();
    public static final int SIZE_OKAY = 0;
    public static final int SIZE_WARNING = 1;
    public static final int SIZE_ERROR = 2;
    protected int headerSize;
    protected int bufferNet;
    protected int bufferLocal;
    protected int chunkSize;
    protected String[] excludedExtensions;
    protected String[] excludedFiles;
    protected Pattern excludedPattern;
    protected File toSearch;
    protected int nesting;
    protected String[] extensions;
    protected Pattern patternName;
    protected Pattern patternContent;
    protected int duplicateMode;
    protected boolean duplicateExact;
    protected long createdStart;
    protected long createdEnd;
    protected long modifiedStart;
    protected long modifiedEnd;
    protected long accessedStart;
    protected long accessedEnd;
    protected long sizeSmallerWarning;
    protected long sizeSmallerError;
    protected long sizeLargerWarning;
    protected long sizeLargerError;
    protected long sizeSmaller;
    protected long sizeLarger;
    protected String fileMode;
    private boolean isCommandLine;
    private final ContentMatcher contentMatcher = new ContentMatcher();

    public Query() {
        this.clear(null);
    }

    @Override
    public boolean isSearchable(String path, BasicFileAttributes attributes) {
        if (this.exclude(path)) {
            return false;
        }
        if (this.fileMode != null && !this.fileMode.equals(path)) {
            return false;
        }
        try {
            return this.containsName(path) && this.withinDate(attributes) && this.withinSize(attributes) && this.containsContent(path);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (!this.isCommandLine) {
                try {
                    Prompt.errorScroll(Resources.__("mainOOMH", new Object[0]), Resources.__("mainOOMMsg", Main.database().numSearched(), path));
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    // empty catch block
                }
            }
            System.exit(1);
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Path root() {
        return Paths.get(this.toSearch.getAbsolutePath(), new String[0]);
    }

    @Override
    public int numLevels() {
        return this.nesting;
    }

    @Override
    public void clear(File file) {
        this.isCommandLine = false;
        this.toSearch = file;
        this.fileMode = null;
        this.contentMatcher.setPattern(null);
        this.nesting = Integer.MAX_VALUE;
        this.extensions = null;
        this.patternName = null;
        this.patternContent = null;
        this.duplicateMode = 0;
        this.duplicateExact = false;
        this.createdStart = -1L;
        this.createdEnd = -1L;
        this.modifiedStart = -1L;
        this.modifiedEnd = -1L;
        this.accessedStart = -1L;
        this.accessedEnd = -1L;
        this.sizeSmallerWarning = -1L;
        this.sizeSmallerError = -1L;
        this.sizeLargerWarning = -1L;
        this.sizeLargerError = -1L;
        this.sizeSmaller = -1L;
        this.sizeLarger = -1L;
    }

    @Override
    public void update() {
        if (Main.frameMain == null) {
            return;
        }
        File oldFile = this.toSearch;
        this.clear(new File(Main.frameMain.main().options.folder.getText()));
        Main.excludeList().setFiles(Main.frameMain.exclude().main().files.getExcludedFiles());
        Main.excludeList().setExt(Main.frameMain.exclude().main().extensions.getExcludedTypes());
        Main.excludeList().setPattern(Main.frameMain.exclude().main().regex.getRegex());
        this.nesting = Main.frameMain.main().options.recurse.getSelectedIndex();
        if (this.nesting == 7) {
            this.nesting = Integer.MAX_VALUE;
        } else if (this.nesting == 0) {
            this.fileMode = this.toSearch.getAbsolutePath();
            this.toSearch = this.toSearch.getParentFile();
            this.nesting = 1;
        } else if (this.nesting == 8) {
            this.toSearch = oldFile;
        }
        String fileTypes = Main.frameMain.main().files.fileTypes.getText();
        this.extensions = fileTypes.length() == 0 || fileTypes.equals("*") ? null : fileTypes.split("[ \t\n,]+");
        String nameText = Main.frameMain.main().options.patternName.getText();
        this.patternName = nameText.length() > 0 ? Pattern.compile(nameText) : null;
        String contentText = Main.frameMain.main().options.patternContent.getText();
        if (contentText.length() > 0) {
            this.patternContent = Pattern.compile(contentText);
            this.contentMatcher.setPattern(this.patternContent);
        } else {
            this.patternContent = null;
        }
        this.duplicateMode = Main.frameMain.main().options.duplicate.getSelectedIndex();
        this.duplicateExact = Main.frameMain.main().options.duplicateExact.isSelected();
        if (Main.frameMain.main().time.modes[0].enabled.isSelected()) {
            PanelTime created = Main.frameMain.main().time.modes[0];
            switch (created.comparison.getSelectedIndex()) {
                case 0: {
                    this.createdStart = -1L;
                    this.createdEnd = created.getTime(created.dateMax);
                    break;
                }
                case 1: {
                    this.createdStart = created.getTime(created.dateMax);
                    this.createdEnd = -1L;
                    break;
                }
                default: {
                    this.createdStart = created.getTime(created.dateMin);
                    this.createdEnd = created.getTime(created.dateMax);
                }
            }
        }
        if (Main.frameMain.main().time.modes[1].enabled.isSelected()) {
            PanelTime modified = Main.frameMain.main().time.modes[1];
            switch (modified.comparison.getSelectedIndex()) {
                case 0: {
                    this.modifiedStart = -1L;
                    this.modifiedEnd = modified.getTime(modified.dateMax);
                    break;
                }
                case 1: {
                    this.modifiedStart = modified.getTime(modified.dateMax);
                    this.modifiedEnd = -1L;
                    break;
                }
                default: {
                    this.modifiedStart = modified.getTime(modified.dateMin);
                    this.modifiedEnd = modified.getTime(modified.dateMax);
                }
            }
        }
        if (Main.frameMain.main().time.modes[2].enabled.isSelected()) {
            PanelTime accessed = Main.frameMain.main().time.modes[2];
            switch (accessed.comparison.getSelectedIndex()) {
                case 0: {
                    this.accessedStart = -1L;
                    this.accessedEnd = accessed.getTime(accessed.dateMax);
                    break;
                }
                case 1: {
                    this.accessedStart = accessed.getTime(accessed.dateMax);
                    this.accessedEnd = -1L;
                    break;
                }
                default: {
                    this.accessedStart = accessed.getTime(accessed.dateMin);
                    this.accessedEnd = accessed.getTime(accessed.dateMax);
                }
            }
        }
        if (Main.frameMain.main().size.mode.getSelectedIndex() != 0) {
            PanelOptionsSize size = Main.frameMain.main().size;
            switch (size.mode.getSelectedIndex()) {
                case 1: {
                    this.sizeSmallerWarning = size.getWarningBytes();
                    this.sizeSmallerError = size.getErrorBytes();
                    break;
                }
                case 2: {
                    this.sizeLargerWarning = size.getWarningBytes();
                    this.sizeLargerError = size.getErrorBytes();
                    break;
                }
                case 3: {
                    this.sizeSmaller = size.getWarningBytes();
                    this.sizeLarger = size.getErrorBytes();
                }
            }
        }
    }

    @Override
    public void loadSearchHash(String hash) {
        if (hash == null) {
            return;
        }
        String[] tokens = hash.split("__FileSearchControlQueryHash__");
        if (tokens.length < 18) {
            return;
        }
        this.toSearch = tokens[0].equals("null") ? null : new File(tokens[0]);
        this.nesting = Integer.parseInt(tokens[1]);
        this.patternName = tokens[2].equals("null") ? null : Pattern.compile(tokens[2]);
        this.patternContent = tokens[3].equals("null") ? null : Pattern.compile(tokens[3]);
        this.duplicateMode = Integer.parseInt(tokens[4]);
        this.duplicateExact = Boolean.parseBoolean(tokens[5]);
        this.createdStart = Long.parseLong(tokens[6]);
        this.createdEnd = Long.parseLong(tokens[7]);
        this.modifiedStart = Long.parseLong(tokens[8]);
        this.modifiedEnd = Long.parseLong(tokens[9]);
        this.accessedStart = Long.parseLong(tokens[10]);
        this.accessedEnd = Long.parseLong(tokens[11]);
        this.sizeSmallerWarning = Long.parseLong(tokens[12]);
        this.sizeSmallerError = Long.parseLong(tokens[13]);
        this.sizeLargerWarning = Long.parseLong(tokens[14]);
        this.sizeLargerError = Long.parseLong(tokens[15]);
        this.sizeSmaller = Long.parseLong(tokens[16]);
        this.sizeLarger = Long.parseLong(tokens[17]);
        this.extensions = null;
        if (tokens.length > 18) {
            this.extensions = new String[tokens.length - 18];
            int i = 0;
            while (i < this.extensions.length) {
                this.extensions[i] = tokens[18 + i];
                ++i;
            }
        }
    }

    @Override
    public String getSearchHash() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.toSearch == null ? "null" : this.toSearch.getAbsolutePath());
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.nesting);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.patternName == null ? "null" : this.patternName);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.patternContent == null ? "null" : this.patternContent);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.duplicateMode);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.duplicateExact);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.createdStart);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.createdEnd);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.modifiedStart);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.modifiedEnd);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.accessedStart);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.accessedEnd);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeSmallerWarning);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeSmallerError);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeLargerWarning);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeLargerError);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeSmaller);
        builder.append("__FileSearchControlQueryHash__");
        builder.append(this.sizeLarger);
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.length) {
                builder.append("__FileSearchControlQueryHash__");
                builder.append(this.extensions[i]);
                ++i;
            }
        }
        return builder.toString();
    }

    @Override
    public Query create() {
        return new Query();
    }

    public FileDisplayTree run(Database database, boolean isCommandLine) {
        boolean curr;
        this.isCommandLine = isCommandLine;
        if (isCommandLine) {
            DuplicateFinder.setHeaderSize(this.headerSize);
            if (FileUtils.isRemote(this.toSearch)) {
                this.contentMatcher.tuneParameters(this.bufferNet, this.chunkSize);
            } else {
                this.contentMatcher.tuneParameters(this.bufferLocal, this.chunkSize);
            }
            Main.excludeList().setFiles(this.excludedFiles);
            Main.excludeList().setExt(this.excludedExtensions);
            Main.excludeList().setPattern(this.excludedPattern);
        } else {
            DuplicateFinder.setHeaderSize(Main.frameMain.developer().main().getHeaderSize());
            if (FileUtils.isRemote(this.toSearch)) {
                this.contentMatcher.tuneParameters(Main.frameMain.developer().main().getBufferNet(), Main.frameMain.developer().main().getChunkSize());
            } else {
                this.contentMatcher.tuneParameters(Main.frameMain.developer().main().getBufferLocal(), Main.frameMain.developer().main().getChunkSize());
            }
        }
        boolean bl = curr = this.nesting == 8;
        if (curr && !isCommandLine) {
            Main.frameMain.main().options.folder.setText(this.toSearch.toString());
            Main.frameMain.main().options.saveView();
        }
        switch (this.duplicateMode) {
            case 1: {
                return database.findDuplicates(false, true, false, this.duplicateExact, curr, null, null, null);
            }
            case 2: {
                return database.findDuplicates(false, false, true, this.duplicateExact, curr, null, null, null);
            }
            case 3: {
                return database.findDuplicates(false, true, true, this.duplicateExact, curr, null, null, null);
            }
        }
        return database.search(false, curr);
    }

    public FileDisplayTree runDuplicates(Database database, String[] searchPaths, long[] searchSizes, String searchRoot, boolean names, boolean content, boolean exact) {
        this.isCommandLine = false;
        DuplicateFinder.setHeaderSize(Main.frameMain.developer().main().getHeaderSize());
        if (FileUtils.isRemote(this.toSearch)) {
            this.contentMatcher.tuneParameters(Main.frameMain.developer().main().getBufferNet(), Main.frameMain.developer().main().getChunkSize());
        } else {
            this.contentMatcher.tuneParameters(Main.frameMain.developer().main().getBufferLocal(), Main.frameMain.developer().main().getChunkSize());
        }
        return database.findDuplicates(false, names, content, exact, false, searchPaths, searchSizes, searchRoot);
    }

    public int getSizeDescriptor(String path) {
        long size = new File(path).length();
        if (this.sizeSmaller >= 0L && this.sizeLarger >= 0L) {
            if (!this.withinRange(size, this.sizeSmaller, this.sizeLarger)) {
                return 2;
            }
        } else if (this.sizeSmallerWarning >= 0L && this.sizeSmallerError >= 0L) {
            if (this.withinRange(size, -1L, this.sizeSmallerError)) {
                return 2;
            }
            if (this.withinRange(size, -1L, this.sizeSmallerWarning)) {
                return 1;
            }
        } else if (this.sizeLargerWarning >= 0L && this.sizeLargerError >= 0L) {
            if (this.withinRange(size, this.sizeLargerError, -1L)) {
                return 2;
            }
            if (this.withinRange(size, this.sizeLargerWarning, -1L)) {
                return 1;
            }
        }
        return 0;
    }

    private boolean exclude(String path) {
        return Main.excludeList().isFileExcluded(path, Ext.get(path));
    }

    private boolean containsName(String path) {
        boolean endsWith;
        boolean bl = endsWith = this.extensions == null;
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.length) {
                if (path.toLowerCase().endsWith(this.extensions[i])) {
                    endsWith = true;
                    break;
                }
                ++i;
            }
        }
        boolean matches = true;
        String name = new File(path).getName();
        if (this.patternName != null) {
            Matcher m = this.patternName.matcher(name);
            matches = m.find();
        }
        return endsWith && matches;
    }

    private boolean containsContent(String path) throws Exception {
        if (this.patternContent != null) {
            return this.contentMatcher.find(path);
        }
        return true;
    }

    private boolean withinDate(BasicFileAttributes attributes) {
        return this.withinRange(attributes.creationTime().toMillis(), this.createdStart, this.createdEnd) && this.withinRange(attributes.lastModifiedTime().toMillis(), this.modifiedStart, this.modifiedEnd) && this.withinRange(attributes.lastAccessTime().toMillis(), this.accessedStart, this.accessedEnd);
    }

    private boolean withinSize(BasicFileAttributes attributes) {
        long size = attributes.size();
        if (this.sizeSmaller >= 0L && this.sizeLarger >= 0L) {
            return this.withinRange(size, this.sizeSmaller, this.sizeLarger);
        }
        if (this.sizeSmallerWarning >= 0L && this.sizeSmallerError >= 0L) {
            return this.withinRange(size, -1L, this.sizeSmallerWarning);
        }
        if (this.sizeLargerWarning >= 0L && this.sizeLargerError >= 0L) {
            return this.withinRange(size, this.sizeLargerWarning, -1L);
        }
        return true;
    }

    private boolean withinRange(long value, long start, long end) {
        if (start < 0L && end < 0L) {
            return true;
        }
        if (end >= 0L && start >= 0L) {
            return value >= start && value <= end;
        }
        if (end < 0L) {
            return value >= start;
        }
        return value <= end;
    }
}

