/*
 * Decompiled with CFR 0.152.
 */
package edu.uwyo;

import edu.uwyo.crawl.Query;
import edu.uwyo.crawl.QueryParams;
import edu.uwyo.crawl.database.Database;
import edu.uwyo.crawl.database.ExcludeList;
import edu.uwyo.crawl.ui.FrameMain;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import net.javamon.dev.Console;
import net.javamon.dev.Prompt;
import net.javamon.dev.Resources;

public final class Main {
    public static FrameMain frameMain;
    private static Database database;
    private static File currSnapshot;
    private static boolean allowWindowKill;

    private Main() {
        throw new AssertionError();
    }

    public static void main(String[] args) {
        String developer;
        Resources.init(".", "fileCrawler");
        Console.init();
        Database.init();
        Console.windowLoad.addKeyListener(new WindowKillListener());
        database = new Database(new Query(), Query.INSTANCE);
        if (args.length > 0) {
            Main.commandMode(args);
            System.exit(0);
        }
        if ((developer = Resources.readUserSetting("developerMode")) != null) {
            database.setDeveloperMode(Boolean.parseBoolean(developer));
        }
        Console.windowLoad.start(null, null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                String lastSnapshot = Resources.readUserSetting("lastSnapshot");
                if (lastSnapshot != null) {
                    currSnapshot = new File(lastSnapshot);
                    if (!currSnapshot.exists() || !database.loadSearchResults(currSnapshot)) {
                        currSnapshot = null;
                        Resources.removeUserSetting("lastSnapshot");
                    }
                }
                frameMain = new FrameMain();
                Console.windowLoad.stop();
                frameMain.show(currSnapshot);
            }
        }).start();
    }

    public static Database database() {
        return database;
    }

    public static Query query() {
        return (Query)database.results().searchControl();
    }

    public static File currSnapshot() {
        return currSnapshot;
    }

    public static ExcludeList excludeList() {
        return database.results().excludeList();
    }

    public static void allowWindowKill(boolean allowKill) {
        allowWindowKill = allowKill;
    }

    public static void loadSnapshot(final File snapshot, final File destination) {
        if (frameMain != null) {
            frameMain.hide();
        }
        Console.windowLoad.start(Resources.__("mainStartLoading", new Object[0]), null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (destination != null && frameMain != null) {
                    frameMain.saveView();
                }
                if (destination == null || database.saveSearchResults(destination)) {
                    if (database.loadSearchResults(snapshot)) {
                        currSnapshot = snapshot;
                        Resources.writeUserSetting("lastSnapshot", currSnapshot.getAbsolutePath());
                        if (frameMain != null) {
                            frameMain.save();
                        }
                    } else {
                        Prompt.message(Resources.__("mainSnapshotLoadErrorH", new Object[0]), Resources.__("mainSnapshotLoadErrorMsg", snapshot.getAbsolutePath()));
                    }
                } else {
                    Prompt.message(Resources.__("mainSnapshotSaveErrorH", new Object[0]), Resources.__("mainSnapshotSaveErrorMsg", snapshot.getAbsolutePath()));
                }
                Console.windowLoad.stop();
                if (frameMain != null) {
                    frameMain.show(currSnapshot);
                }
            }
        }).start();
    }

    public static void saveSnapshot(final File snapshot) {
        frameMain.hide();
        Console.windowLoad.start(null, null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                frameMain.saveView();
                if (database.saveSearchResults(snapshot)) {
                    currSnapshot = snapshot;
                }
                if (currSnapshot != null) {
                    Resources.writeUserSetting("lastSnapshot", currSnapshot.getAbsolutePath());
                }
                Console.windowLoad.stop();
                frameMain.save();
                frameMain.show(currSnapshot);
            }
        }).start();
    }

    public static String readSetting(String setting) {
        return database.results().readSetting(setting);
    }

    public static void writeSetting(String setting, String value) {
        database.results().writeSetting(setting, value);
    }

    public static Byte getFlag(String path) {
        return database.results().getFlag(path);
    }

    public static void setFlag(String path, byte flag) {
        database.results().setFlag(path, flag);
    }

    public static void removeFlag(String path) {
        database.results().removeFlag(path);
    }

    public static void removeAllFlags() {
        database.results().removeAllFlags();
    }

    public static void quit(final File snapshot) {
        if (snapshot == null) {
            if (currSnapshot != null) {
                Resources.writeUserSetting("lastSnapshot", currSnapshot.getAbsolutePath());
            }
            System.exit(0);
        }
        frameMain.hide();
        Console.windowLoad.start(Resources.__("mainExitLoading", new Object[0]), null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (snapshot != null) {
                    frameMain.saveView();
                    if (database.saveSearchResults(snapshot)) {
                        currSnapshot = snapshot;
                    }
                }
                if (currSnapshot != null) {
                    Resources.writeUserSetting("lastSnapshot", currSnapshot.getAbsolutePath());
                }
                Console.windowLoad.stop();
                System.exit(0);
            }
        }).start();
    }

    private static void commandMode(String[] args) {
        QueryParams queryParams = new QueryParams(database);
        if (queryParams.parse(args)) {
            queryParams.run();
        }
    }

    private static class WindowKillListener
    implements KeyListener {
        private WindowKillListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27 && allowWindowKill) {
                System.exit(1);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }
}

