/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Transition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class StringUnionOperations {
    public static final Comparator<CharSequence> LEXICOGRAPHIC_ORDER = new Comparator<CharSequence>(){

        @Override
        public int compare(CharSequence s1, CharSequence s2) {
            int lens1 = s1.length();
            int lens2 = s2.length();
            int max = Math.min(lens1, lens2);
            int i = 0;
            while (i < max) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 != (c2 = s2.charAt(i))) {
                    return c1 - c2;
                }
                ++i;
            }
            return lens1 - lens2;
        }
    };
    private HashMap<State, State> register = new HashMap();
    private State root = new State();
    private StringBuilder previous;

    public void add(CharSequence current) {
        State next;
        assert (this.register != null) : "Automaton already built.";
        assert (current.length() > 0) : "Input sequences must not be empty.";
        assert (this.previous == null || LEXICOGRAPHIC_ORDER.compare(this.previous, current) <= 0) : "Input must be sorted: " + this.previous + " >= " + current;
        assert (this.setPrevious(current));
        int pos = 0;
        int max = current.length();
        State state = this.root;
        while (pos < max && (next = state.lastChild(current.charAt(pos))) != null) {
            state = next;
            ++pos;
        }
        if (state.hasChildren()) {
            this.replaceOrRegister(state);
        }
        this.addSuffix(state, current, pos);
    }

    public State complete() {
        if (this.register == null) {
            throw new IllegalStateException();
        }
        if (this.root.hasChildren()) {
            this.replaceOrRegister(this.root);
        }
        this.register = null;
        return this.root;
    }

    private static dk.brics.automaton.State convert(State s, IdentityHashMap<State, dk.brics.automaton.State> visited) {
        dk.brics.automaton.State converted = visited.get(s);
        if (converted != null) {
            return converted;
        }
        converted = new dk.brics.automaton.State();
        converted.setAccept(s.is_final);
        visited.put(s, converted);
        int i = 0;
        char[] labels = s.labels;
        State[] stateArray = s.states;
        int n = s.states.length;
        int n2 = 0;
        while (n2 < n) {
            State target = stateArray[n2];
            converted.addTransition(new Transition(labels[i++], StringUnionOperations.convert(target, visited)));
            ++n2;
        }
        return converted;
    }

    public static dk.brics.automaton.State build(CharSequence[] input) {
        StringUnionOperations builder = new StringUnionOperations();
        CharSequence[] charSequenceArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence chs = charSequenceArray[n2];
            builder.add(chs);
            ++n2;
        }
        return StringUnionOperations.convert(builder.complete(), new IdentityHashMap<State, dk.brics.automaton.State>());
    }

    private boolean setPrevious(CharSequence current) {
        if (this.previous == null) {
            this.previous = new StringBuilder();
        }
        this.previous.setLength(0);
        this.previous.append(current);
        return true;
    }

    private void replaceOrRegister(State state) {
        State registered;
        State child = state.lastChild();
        if (child.hasChildren()) {
            this.replaceOrRegister(child);
        }
        if ((registered = this.register.get(child)) != null) {
            state.replaceLastChild(registered);
        } else {
            this.register.put(child, child);
        }
    }

    private void addSuffix(State state, CharSequence current, int fromIndex) {
        int len = current.length();
        int i = fromIndex;
        while (i < len) {
            state = state.newState(current.charAt(i));
            ++i;
        }
        state.is_final = true;
    }

    static final class State {
        private static final char[] NO_LABELS = new char[0];
        private static final State[] NO_STATES = new State[0];
        char[] labels = NO_LABELS;
        State[] states = NO_STATES;
        boolean is_final;

        State() {
        }

        public State getState(char label) {
            int index = Arrays.binarySearch(this.labels, label);
            return index >= 0 ? this.states[index] : null;
        }

        public char[] getTransitionLabels() {
            return this.labels;
        }

        public State[] getStates() {
            return this.states;
        }

        public boolean equals(Object obj) {
            State other = (State)obj;
            return this.is_final == other.is_final && Arrays.equals(this.labels, other.labels) && State.referenceEquals(this.states, other.states);
        }

        public boolean hasChildren() {
            return this.labels.length > 0;
        }

        public boolean isFinal() {
            return this.is_final;
        }

        public int hashCode() {
            int hash = this.is_final ? 1 : 0;
            hash ^= hash * 31 + this.labels.length;
            Object[] objectArray = this.labels;
            int n = this.labels.length;
            int n2 = 0;
            while (n2 < n) {
                char c = objectArray[n2];
                hash ^= hash * 31 + c;
                ++n2;
            }
            objectArray = this.states;
            n = this.states.length;
            n2 = 0;
            while (n2 < n) {
                char s = objectArray[n2];
                hash ^= System.identityHashCode(s);
                ++n2;
            }
            return hash;
        }

        State newState(char label) {
            assert (Arrays.binarySearch(this.labels, label) < 0) : "State already has transition labeled: " + label;
            this.labels = State.copyOf(this.labels, this.labels.length + 1);
            this.states = State.copyOf(this.states, this.states.length + 1);
            this.labels[this.labels.length - 1] = label;
            State state = new State();
            this.states[this.states.length - 1] = state;
            return state;
        }

        State lastChild() {
            assert (this.hasChildren()) : "No outgoing transitions.";
            return this.states[this.states.length - 1];
        }

        State lastChild(char label) {
            int index = this.labels.length - 1;
            State s = null;
            if (index >= 0 && this.labels[index] == label) {
                s = this.states[index];
            }
            assert (s == this.getState(label));
            return s;
        }

        void replaceLastChild(State state) {
            assert (this.hasChildren()) : "No outgoing transitions.";
            this.states[this.states.length - 1] = state;
        }

        private static char[] copyOf(char[] original, int newLength) {
            char[] copy = new char[newLength];
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
            return copy;
        }

        public static State[] copyOf(State[] original, int newLength) {
            State[] copy = new State[newLength];
            System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
            return copy;
        }

        private static boolean referenceEquals(Object[] a1, Object[] a2) {
            if (a1.length != a2.length) {
                return false;
            }
            int i = 0;
            while (i < a1.length) {
                if (a1[i] != a2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

