/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.AutomatonMatcher;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Set;

public class RunAutomaton
implements Serializable {
    static final long serialVersionUID = 20001L;
    int size;
    boolean[] accept;
    int initial;
    int[] transitions;
    char[] points;
    int[] classmap;

    void setAlphabet() {
        this.classmap = new int[65536];
        int i = 0;
        char j = '\u0000';
        while (j <= '\uffff') {
            if (i + 1 >= this.points.length || j == this.points[i + 1]) {
                // empty if block
            }
            this.classmap[j] = ++i;
            ++j;
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("initial state: ").append(this.initial).append("\n");
        int i = 0;
        while (i < this.size) {
            b.append("state ").append(i);
            if (this.accept[i]) {
                b.append(" [accept]:\n");
            } else {
                b.append(" [reject]:\n");
            }
            int j = 0;
            while (j < this.points.length) {
                int k = this.transitions[i * this.points.length + j];
                if (k != -1) {
                    char min = this.points[j];
                    char max = j + 1 < this.points.length ? (char)((char)(this.points[j + 1] - '\u0001')) : (char)'\uffff';
                    b.append(" ");
                    Transition.appendCharString(min, b);
                    if (min != max) {
                        b.append("-");
                        Transition.appendCharString(max, b);
                    }
                    b.append(" -> ").append(k).append("\n");
                }
                ++j;
            }
            ++i;
        }
        return b.toString();
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAccept(int state) {
        return this.accept[state];
    }

    public int getInitialState() {
        return this.initial;
    }

    public char[] getCharIntervals() {
        return (char[])this.points.clone();
    }

    int getCharClass(char c) {
        return SpecialOperations.findIndex(c, this.points);
    }

    private RunAutomaton() {
    }

    public RunAutomaton(Automaton a) {
        this(a, true);
    }

    public static RunAutomaton load(URL url) throws IOException, ClassCastException, ClassNotFoundException {
        return RunAutomaton.load(url.openStream());
    }

    public static RunAutomaton load(InputStream stream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream s = new ObjectInputStream(stream);
        return (RunAutomaton)s.readObject();
    }

    public void store(OutputStream stream) throws IOException {
        ObjectOutputStream s = new ObjectOutputStream(stream);
        s.writeObject(this);
        s.flush();
    }

    public RunAutomaton(Automaton a, boolean tableize) {
        a.determinize();
        this.points = a.getStartPoints();
        Set<State> states = a.getStates();
        Automaton.setStateNumbers(states);
        this.initial = a.initial.number;
        this.size = states.size();
        this.accept = new boolean[this.size];
        this.transitions = new int[this.size * this.points.length];
        int n = 0;
        while (n < this.size * this.points.length) {
            this.transitions[n] = -1;
            ++n;
        }
        for (State s : states) {
            int n2 = s.number;
            this.accept[n2] = s.accept;
            int c = 0;
            while (c < this.points.length) {
                State q = s.step(this.points[c]);
                if (q != null) {
                    this.transitions[n2 * this.points.length + c] = q.number;
                }
                ++c;
            }
        }
        if (tableize) {
            this.setAlphabet();
        }
    }

    public int step(int state, char c) {
        if (this.classmap == null) {
            return this.transitions[state * this.points.length + this.getCharClass(c)];
        }
        return this.transitions[state * this.points.length + this.classmap[c - '\u0000']];
    }

    public boolean run(String s) {
        int p = this.initial;
        int l = s.length();
        int i = 0;
        while (i < l) {
            if ((p = this.step(p, s.charAt(i))) == -1) {
                return false;
            }
            ++i;
        }
        return this.accept[p];
    }

    public int run(String s, int offset) {
        int p = this.initial;
        int l = s.length();
        int max = -1;
        int r = 0;
        while (offset <= l) {
            if (this.accept[p]) {
                max = r;
            }
            if (offset == l || (p = this.step(p, s.charAt(offset))) == -1) break;
            ++offset;
            ++r;
        }
        return max;
    }

    public AutomatonMatcher newMatcher(CharSequence s) {
        return new AutomatonMatcher(s, this);
    }

    public AutomatonMatcher newMatcher(CharSequence s, int startOffset, int endOffset) {
        return new AutomatonMatcher(s.subSequence(startOffset, endOffset), this);
    }
}

