/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.Automaton;
import dk.brics.automaton.BasicOperations;
import dk.brics.automaton.SpecialOperations;
import dk.brics.automaton.State;
import dk.brics.automaton.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class MinimizationOperations {
    private MinimizationOperations() {
    }

    public static void minimize(Automaton a) {
        if (!a.isSingleton()) {
            switch (Automaton.minimization) {
                case 0: {
                    MinimizationOperations.minimizeHuffman(a);
                    break;
                }
                case 1: {
                    MinimizationOperations.minimizeBrzozowski(a);
                    break;
                }
                case 3: {
                    MinimizationOperations.minimizeValmari(a);
                    break;
                }
                default: {
                    MinimizationOperations.minimizeHopcroft(a);
                }
            }
        }
        a.recomputeHashCode();
    }

    private static boolean statesAgree(Transition[][] transitions, boolean[][] mark, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            int m1 = t1[k1].to.number;
            int m2 = t2[k2].to.number;
            if (m1 > m2) {
                int t = m1;
                m1 = m2;
                m2 = t;
            }
            if (mark[m1][m2]) {
                return false;
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
        return true;
    }

    private static void addTriggers(Transition[][] transitions, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        Transition[] t1 = transitions[n1];
        Transition[] t2 = transitions[n2];
        int k1 = 0;
        int k2 = 0;
        while (k1 < t1.length && k2 < t2.length) {
            if (t1[k1].max < t2[k2].min) {
                ++k1;
                continue;
            }
            if (t2[k2].max < t1[k1].min) {
                ++k2;
                continue;
            }
            if (t1[k1].to != t2[k2].to) {
                int m1 = t1[k1].to.number;
                int m2 = t2[k2].to.number;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (triggers.get(m1).get(m2) == null) {
                    triggers.get(m1).set(m2, new HashSet());
                }
                triggers.get(m1).get(m2).add(new IntPair(n1, n2));
            }
            if (t1[k1].max < t2[k2].max) {
                ++k1;
                continue;
            }
            ++k2;
        }
    }

    private static void markPair(boolean[][] mark, ArrayList<ArrayList<HashSet<IntPair>>> triggers, int n1, int n2) {
        mark[n1][n2] = true;
        if (triggers.get(n1).get(n2) != null) {
            for (IntPair p : triggers.get(n1).get(n2)) {
                int m1 = p.n1;
                int m2 = p.n2;
                if (m1 > m2) {
                    int t = m1;
                    m1 = m2;
                    m2 = t;
                }
                if (mark[m1][m2]) continue;
                MinimizationOperations.markPair(mark, triggers, m1, m2);
            }
        }
    }

    private static <T> void initialize(ArrayList<T> list, int size) {
        int i = 0;
        while (i < size) {
            list.add(null);
            ++i;
        }
    }

    public static void minimizeHuffman(Automaton a) {
        a.determinize();
        a.totalize();
        Set<State> ss = a.getStates();
        Transition[][] transitions = new Transition[ss.size()][];
        State[] states = ss.toArray(new State[ss.size()]);
        boolean[][] mark = new boolean[states.length][states.length];
        ArrayList<ArrayList<HashSet<IntPair>>> triggers = new ArrayList<ArrayList<HashSet<IntPair>>>();
        int n1 = 0;
        while (n1 < states.length) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, states.length);
            triggers.add(v);
            ++n1;
        }
        n1 = 0;
        while (n1 < states.length) {
            states[n1].number = n1;
            transitions[n1] = states[n1].getSortedTransitionArray(false);
            int n2 = n1 + 1;
            while (n2 < states.length) {
                if (states[n1].accept != states[n2].accept) {
                    mark[n1][n2] = true;
                }
                ++n2;
            }
            ++n1;
        }
        n1 = 0;
        while (n1 < states.length) {
            int n2 = n1 + 1;
            while (n2 < states.length) {
                if (!mark[n1][n2]) {
                    if (MinimizationOperations.statesAgree(transitions, mark, n1, n2)) {
                        MinimizationOperations.addTriggers(transitions, triggers, n1, n2);
                    } else {
                        MinimizationOperations.markPair(mark, triggers, n1, n2);
                    }
                }
                ++n2;
            }
            ++n1;
        }
        int numclasses = 0;
        int n = 0;
        while (n < states.length) {
            states[n].number = -1;
            ++n;
        }
        int n12 = 0;
        while (n12 < states.length) {
            if (states[n12].number == -1) {
                states[n12].number = numclasses;
                int n2 = n12 + 1;
                while (n2 < states.length) {
                    if (!mark[n12][n2]) {
                        states[n2].number = numclasses;
                    }
                    ++n2;
                }
                ++numclasses;
            }
            ++n12;
        }
        State[] newstates = new State[numclasses];
        int n2 = 0;
        while (n2 < numclasses) {
            newstates[n2] = new State();
            ++n2;
        }
        n2 = 0;
        while (n2 < states.length) {
            newstates[states[n2].number].number = n2;
            if (states[n2] == a.initial) {
                a.initial = newstates[states[n2].number];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < numclasses) {
            State s = newstates[n2];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
            ++n2;
        }
        a.removeDeadTransitions();
    }

    public static void minimizeBrzozowski(Automaton a) {
        if (a.isSingleton()) {
            return;
        }
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
        BasicOperations.determinize(a, SpecialOperations.reverse(a));
    }

    public static void minimizeHopcroft(Automaton a) {
        a.determinize();
        Set<Transition> tr = a.initial.getTransitions();
        if (tr.size() == 1) {
            Transition t = tr.iterator().next();
            if (t.to == a.initial && t.min == '\u0000' && t.max == '\uffff') {
                return;
            }
        }
        a.totalize();
        Set<State> ss = a.getStates();
        State[] states = new State[ss.size()];
        int number = 0;
        Iterator<State> iterator = ss.iterator();
        while (iterator.hasNext()) {
            State q;
            states[number] = q = iterator.next();
            q.number = number++;
        }
        char[] sigma = a.getStartPoints();
        ArrayList reverse = new ArrayList();
        int q = 0;
        while (q < states.length) {
            ArrayList v = new ArrayList();
            MinimizationOperations.initialize(v, sigma.length);
            reverse.add(v);
            ++q;
        }
        boolean[][] reverse_nonempty = new boolean[states.length][sigma.length];
        ArrayList partition = new ArrayList();
        MinimizationOperations.initialize(partition, states.length);
        int[] block = new int[states.length];
        StateList[][] active = new StateList[states.length][sigma.length];
        StateListNode[][] active2 = new StateListNode[states.length][sigma.length];
        LinkedList<IntPair> pending = new LinkedList<IntPair>();
        boolean[][] pending2 = new boolean[sigma.length][states.length];
        ArrayList<State> split = new ArrayList<State>();
        boolean[] split2 = new boolean[states.length];
        ArrayList<Integer> refine = new ArrayList<Integer>();
        boolean[] refine2 = new boolean[states.length];
        ArrayList splitblock = new ArrayList();
        MinimizationOperations.initialize(splitblock, states.length);
        int q2 = 0;
        while (q2 < states.length) {
            splitblock.set(q2, new ArrayList());
            partition.set(q2, new LinkedList());
            int x = 0;
            while (x < sigma.length) {
                ((ArrayList)reverse.get(q2)).set(x, new LinkedList());
                active[q2][x] = new StateList();
                ++x;
            }
            ++q2;
        }
        q2 = 0;
        while (q2 < states.length) {
            State qq = states[q2];
            int j = qq.accept ? 0 : 1;
            ((LinkedList)partition.get(j)).add(qq);
            block[qq.number] = j;
            int x = 0;
            while (x < sigma.length) {
                char y = sigma[x];
                State p = qq.step(y);
                ((LinkedList)((ArrayList)reverse.get(p.number)).get(x)).add(qq);
                reverse_nonempty[p.number][x] = true;
                ++x;
            }
            ++q2;
        }
        int j = 0;
        while (j <= 1) {
            int x = 0;
            while (x < sigma.length) {
                for (State qq : (LinkedList)partition.get(j)) {
                    if (!reverse_nonempty[qq.number][x]) continue;
                    active2[qq.number][x] = active[j][x].add(qq);
                }
                ++x;
            }
            ++j;
        }
        int x = 0;
        while (x < sigma.length) {
            int a0 = active[0][x].size;
            int a1 = active[1][x].size;
            int j2 = a0 <= a1 ? 0 : 1;
            pending.add(new IntPair(j2, x));
            pending2[x][j2] = true;
            ++x;
        }
        int k = 2;
        while (!pending.isEmpty()) {
            IntPair ip = (IntPair)pending.removeFirst();
            int p = ip.n1;
            int x2 = ip.n2;
            pending2[x2][p] = false;
            StateListNode m = active[p][x2].first;
            while (m != null) {
                for (State s : (LinkedList)((ArrayList)reverse.get(m.q.number)).get(x2)) {
                    if (split2[s.number]) continue;
                    split2[s.number] = true;
                    split.add(s);
                    int j3 = block[s.number];
                    ((ArrayList)splitblock.get(j3)).add(s);
                    if (refine2[j3]) continue;
                    refine2[j3] = true;
                    refine.add(j3);
                }
                m = m.next;
            }
            Iterator<Object> iterator2 = refine.iterator();
            while (iterator2.hasNext()) {
                int j4 = (Integer)iterator2.next();
                if (((ArrayList)splitblock.get(j4)).size() < ((LinkedList)partition.get(j4)).size()) {
                    LinkedList b1 = (LinkedList)partition.get(j4);
                    LinkedList b2 = (LinkedList)partition.get(k);
                    for (State s : (ArrayList)splitblock.get(j4)) {
                        b1.remove(s);
                        b2.add(s);
                        block[s.number] = k;
                        int c = 0;
                        while (c < sigma.length) {
                            StateListNode sn = active2[s.number][c];
                            if (sn != null && sn.sl == active[j4][c]) {
                                sn.remove();
                                active2[s.number][c] = active[k][c].add(s);
                            }
                            ++c;
                        }
                    }
                    int c = 0;
                    while (c < sigma.length) {
                        int aj = active[j4][c].size;
                        int ak = active[k][c].size;
                        if (!pending2[c][j4] && aj > 0 && aj <= ak) {
                            pending2[c][j4] = true;
                            pending.add(new IntPair(j4, c));
                        } else {
                            pending2[c][k] = true;
                            pending.add(new IntPair(k, c));
                        }
                        ++c;
                    }
                    ++k;
                }
                for (State s : (ArrayList)splitblock.get(j4)) {
                    split2[s.number] = false;
                }
                refine2[j4] = false;
                ((ArrayList)splitblock.get(j4)).clear();
            }
            split.clear();
            refine.clear();
        }
        State[] newstates = new State[k];
        int n = 0;
        while (n < newstates.length) {
            State s;
            newstates[n] = s = new State();
            for (State q3 : (LinkedList)partition.get(n)) {
                if (q3 == a.initial) {
                    a.initial = s;
                }
                s.accept = q3.accept;
                s.number = q3.number;
                q3.number = n;
            }
            ++n;
        }
        n = 0;
        while (n < newstates.length) {
            State s = newstates[n];
            s.accept = states[s.number].accept;
            for (Transition t : states[s.number].transitions) {
                s.transitions.add(new Transition(t.min, t.max, newstates[t.to.number]));
            }
            ++n;
        }
        a.removeDeadTransitions();
    }

    public static void minimizeValmari(Automaton automaton) {
        automaton.determinize();
        Set<State> states = automaton.getStates();
        MinimizationOperations.splitTransitions(states);
        int stateCount = states.size();
        int transitionCount = automaton.getNumberOfTransitions();
        Set<State> acceptStates = automaton.getAcceptStates();
        Partition blocks = new Partition(stateCount);
        Partition cords = new Partition(transitionCount);
        IntPair[] labels = new IntPair[transitionCount];
        int[] tails = new int[transitionCount];
        int[] heads = new int[transitionCount];
        Automaton.setStateNumbers(states);
        int number = 0;
        for (State s : automaton.getStates()) {
            for (Transition t : s.getTransitions()) {
                tails[number] = s.number;
                labels[number] = new IntPair(t.min, t.max);
                heads[number] = t.getDest().number;
                ++number;
            }
        }
        for (State s : acceptStates) {
            blocks.mark(s.number);
        }
        blocks.split();
        if (transitionCount > 0) {
            Arrays.sort(cords.elements, new LabelComparator(labels));
            cords.markedElementCount[0] = 0;
            cords.setCount = 0;
            IntPair a = labels[cords.elements[0]];
            int i = 0;
            while (i < transitionCount) {
                int t = cords.elements[i];
                if (labels[t].n1 != a.n1 || labels[t].n2 != a.n2) {
                    a = labels[t];
                    cords.past[cords.setCount++] = i;
                    cords.first[cords.setCount] = i;
                    cords.markedElementCount[cords.setCount] = 0;
                }
                cords.setNo[t] = cords.setCount;
                cords.locations[t] = i++;
            }
            cords.past[cords.setCount++] = transitionCount;
        }
        int[] A = new int[transitionCount];
        int[] F = new int[stateCount + 1];
        MinimizationOperations.makeAdjacent(A, F, heads, stateCount, transitionCount);
        int c = 0;
        while (c < cords.setCount) {
            int i = cords.first[c];
            while (i < cords.past[c]) {
                blocks.mark(tails[cords.elements[i]]);
                ++i;
            }
            blocks.split();
            int b = 1;
            while (b < blocks.setCount) {
                int i2 = blocks.first[b];
                while (i2 < blocks.past[b]) {
                    int j = F[blocks.elements[i2]];
                    while (j < F[blocks.elements[i2] + 1]) {
                        cords.mark(A[j]);
                        ++j;
                    }
                    ++i2;
                }
                cords.split();
                ++b;
            }
            ++c;
        }
        State[] newStates = new State[blocks.setCount];
        int bl = 0;
        while (bl < blocks.setCount) {
            newStates[bl] = new State();
            if (blocks.first[bl] < acceptStates.size()) {
                newStates[bl].accept = true;
            }
            ++bl;
        }
        int t = 0;
        while (t < transitionCount) {
            if (blocks.locations[tails[t]] == blocks.first[blocks.setNo[tails[t]]]) {
                State tail = newStates[blocks.setNo[tails[t]]];
                State head = newStates[blocks.setNo[heads[t]]];
                tail.addTransition(new Transition((char)labels[t].n1, (char)labels[t].n2, head));
            }
            ++t;
        }
        automaton.setInitialState(newStates[blocks.setNo[automaton.getInitialState().number]]);
        automaton.reduce();
    }

    private static void makeAdjacent(int[] A, int[] F, int[] K, int nn, int mm) {
        int q = 0;
        while (q <= nn) {
            F[q] = 0;
            ++q;
        }
        int t = 0;
        while (t < mm) {
            int n = K[t];
            F[n] = F[n] + 1;
            ++t;
        }
        q = 0;
        while (q < nn) {
            int n = q + 1;
            F[n] = F[n] + F[q];
            ++q;
        }
        t = mm;
        while (t-- > 0) {
            int n = K[t];
            int n2 = F[n] - 1;
            F[n] = n2;
            A[n2] = t;
        }
    }

    private static void splitTransitions(Set<State> states) {
        TreeSet<Character> pointSet = new TreeSet<Character>();
        for (State s : states) {
            for (Transition t : s.getTransitions()) {
                pointSet.add(Character.valueOf(t.min));
                pointSet.add(Character.valueOf(t.max));
            }
        }
        for (State s : states) {
            Set<Transition> transitions = s.getTransitions();
            s.resetTransitions();
            for (Transition t : transitions) {
                if (t.min == t.max) {
                    s.addTransition(t);
                    continue;
                }
                NavigableSet<Character> headSet = pointSet.headSet(Character.valueOf(t.max), true);
                NavigableSet<Character> tailSet = pointSet.tailSet(Character.valueOf(t.min), false);
                TreeSet<Character> intersection = new TreeSet<Character>((SortedSet<Character>)headSet);
                intersection.retainAll(tailSet);
                char start = t.min;
                for (Character c : intersection) {
                    s.addTransition(new Transition(start, t.to));
                    s.addTransition(new Transition(c.charValue(), t.to));
                    if (c.charValue() - start > 1) {
                        s.addTransition(new Transition((char)(start + '\u0001'), (char)(c.charValue() - '\u0001'), t.to));
                    }
                    start = c.charValue();
                }
            }
        }
    }

    static class IntPair {
        int n1;
        int n2;

        IntPair(int n1, int n2) {
            this.n1 = n1;
            this.n2 = n2;
        }
    }

    static class LabelComparator
    implements Comparator<Integer> {
        private IntPair[] labels;

        LabelComparator(IntPair[] labels) {
            this.labels = labels;
        }

        @Override
        public int compare(Integer i, Integer j) {
            IntPair p1 = this.labels[i];
            IntPair p2 = this.labels[j];
            if (p1.n1 < p2.n1) {
                return -1;
            }
            if (p1.n1 > p2.n1) {
                return 1;
            }
            if (p1.n2 < p2.n2) {
                return -1;
            }
            if (p1.n2 > p2.n2) {
                return 1;
            }
            return 0;
        }
    }

    static class Partition {
        int[] markedElementCount;
        int[] touchedSets;
        int touchedSetCount;
        int setCount;
        Integer[] elements;
        int[] locations;
        int[] setNo;
        int[] first;
        int[] past;

        Partition(int size) {
            this.setCount = size == 0 ? 0 : 1;
            this.elements = new Integer[size];
            this.locations = new int[size];
            this.setNo = new int[size];
            this.first = new int[size];
            this.past = new int[size];
            this.markedElementCount = new int[size];
            this.touchedSets = new int[size];
            int i = 0;
            while (i < size) {
                this.locations[i] = i;
                this.elements[i] = this.locations[i];
                this.setNo[i] = 0;
                ++i;
            }
            if (this.setCount != 0) {
                this.first[0] = 0;
                this.past[0] = size;
            }
        }

        void mark(int e) {
            int s = this.setNo[e];
            int i = this.locations[e];
            int j = this.first[s] + this.markedElementCount[s];
            this.elements[i] = this.elements[j];
            this.locations[this.elements[i].intValue()] = i;
            this.elements[j] = e;
            this.locations[e] = j;
            int n = s;
            int n2 = this.markedElementCount[n];
            this.markedElementCount[n] = n2 + 1;
            if (n2 == 0) {
                this.touchedSets[this.touchedSetCount++] = s;
            }
        }

        void split() {
            while (this.touchedSetCount > 0) {
                int s;
                int j;
                if ((j = this.first[s = this.touchedSets[--this.touchedSetCount]] + this.markedElementCount[s]) == this.past[s]) {
                    this.markedElementCount[s] = 0;
                    continue;
                }
                if (this.markedElementCount[s] <= this.past[s] - j) {
                    this.first[this.setCount] = this.first[s];
                    this.past[this.setCount] = this.first[s] = j;
                } else {
                    this.past[this.setCount] = this.past[s];
                    this.first[this.setCount] = this.past[s] = j;
                }
                int i = this.first[this.setCount];
                while (i < this.past[this.setCount]) {
                    this.setNo[this.elements[i].intValue()] = this.setCount;
                    ++i;
                }
                this.markedElementCount[this.setCount++] = 0;
                this.markedElementCount[s] = 0;
            }
        }
    }

    static class StateList {
        int size;
        StateListNode first;
        StateListNode last;

        StateList() {
        }

        StateListNode add(State q) {
            return new StateListNode(q, this);
        }
    }

    static class StateListNode {
        State q;
        StateListNode next;
        StateListNode prev;
        StateList sl;

        StateListNode(State q, StateList sl) {
            this.q = q;
            this.sl = sl;
            if (sl.size++ == 0) {
                sl.first = sl.last = this;
            } else {
                sl.last.next = this;
                this.prev = sl.last;
                sl.last = this;
            }
        }

        void remove() {
            --this.sl.size;
            if (this.sl.first == this) {
                this.sl.first = this.next;
            } else {
                this.prev.next = this.next;
            }
            if (this.sl.last == this) {
                this.sl.last = this.prev;
            } else {
                this.next.prev = this.prev;
            }
        }
    }
}

