/*
 * Decompiled with CFR 0.152.
 */
package dk.brics.automaton;

import dk.brics.automaton.RunAutomaton;
import java.util.regex.MatchResult;

public class AutomatonMatcher
implements MatchResult {
    private final RunAutomaton automaton;
    private final CharSequence chars;
    private int matchStart = -1;
    private int matchEnd = -1;

    AutomatonMatcher(CharSequence chars, RunAutomaton automaton) {
        this.chars = chars;
        this.automaton = automaton;
    }

    public boolean find() {
        int match_end;
        int match_start;
        int begin;
        switch (this.getMatchStart()) {
            case -2: {
                return false;
            }
            case -1: {
                begin = 0;
                break;
            }
            default: {
                begin = this.getMatchEnd();
                if (begin != this.getMatchStart() || ++begin <= this.getChars().length()) break;
                this.setMatch(-2, -2);
                return false;
            }
        }
        if (this.automaton.isAccept(this.automaton.getInitialState())) {
            match_start = begin;
            match_end = begin;
        } else {
            match_start = -1;
            match_end = -1;
        }
        int l = this.getChars().length();
        while (begin < l) {
            int p = this.automaton.getInitialState();
            int i = begin;
            while (i < l) {
                int new_state = this.automaton.step(p, this.getChars().charAt(i));
                if (new_state == -1) break;
                if (this.automaton.isAccept(new_state)) {
                    match_start = begin;
                    match_end = i + 1;
                }
                p = new_state;
                ++i;
            }
            if (match_start != -1) {
                this.setMatch(match_start, match_end);
                return true;
            }
            ++begin;
        }
        if (match_start != -1) {
            this.setMatch(match_start, match_end);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int matchStart, int matchEnd) throws IllegalArgumentException {
        if (matchStart > matchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + matchStart + ", " + matchEnd);
        }
        this.matchStart = matchStart;
        this.matchEnd = matchEnd;
    }

    private int getMatchStart() {
        return this.matchStart;
    }

    private int getMatchEnd() {
        return this.matchEnd;
    }

    private CharSequence getChars() {
        return this.chars;
    }

    @Override
    public int end() throws IllegalStateException {
        this.matchGood();
        return this.matchEnd;
    }

    @Override
    public int end(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.end();
    }

    @Override
    public String group() throws IllegalStateException {
        this.matchGood();
        return this.chars.subSequence(this.matchStart, this.matchEnd).toString();
    }

    @Override
    public String group(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() throws IllegalStateException {
        this.matchGood();
        return this.matchStart;
    }

    @Override
    public int start(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.start();
    }

    public MatchResult toMatchResult() {
        AutomatonMatcher match = new AutomatonMatcher(this.chars, this.automaton);
        match.matchStart = this.matchStart;
        match.matchEnd = this.matchEnd;
        return match;
    }

    private static void onlyZero(int group) throws IndexOutOfBoundsException {
        if (group != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    private void matchGood() throws IllegalStateException {
        if (this.matchStart < 0 || this.matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

